import numpy as np
from datetime import datetime
from re import sub

txtfile = 'GPS_Antenna_Infos.Final'
sats = []
dts = []
antenna = []
for line in open(txtfile,'r'):
    if line[0] == ' ':
        sats.append('G' + sub(r' ', r'0', line[1:3]))
    elif line[0] == '1':
        sats.append('R' + line[1:3])
    elif line[0] == '2':
        sats.append('E' + line[1:3])
    elif line[0] == '4':
        sats.append('C' + line[1:3])
    else:
        continue
    dts.append([datetime.strptime(line[4:23],'%Y %m %d %H %M %S'),
                datetime.strptime(line[25:44],'%Y %m %d %H %M %S')])
    antenna.append([float(x) for x in line[44:].strip().split()])
sats = np.array(sats)
dts = np.array(dts)
antenna = np.array(antenna)
usat = np.unique(sats)
data = dict()
for sat in usat:
    sidx = sats == sat
    data[sat] = {'dt_rng':dts[sidx], 'antenna':antenna[sidx]}
np.savez('GPS_Antenna_Infos.npz', **data)