import numpy as np
from datetime import datetime

def to_datetime(dtlist):
    return datetime(int(dtlist[0]), int(dtlist[1]), int(dtlist[2]),int(dtlist[3]),int(dtlist[4]),int(float(dtlist[5])),round((float(dtlist[5])%1)*1E6))

def read_GNSS(file):
    Gsats = []
    Gdata = []
    isdata = False
    for line in open(file,'r'):
        if not isdata and line.startswith('+ '):
            Gsats = Gsats + [line[x:x + 3] for x in range(9, 60, 3) if line[x:x + 3] != '  0']
        elif not isdata and line.startswith('*'):
            isdata = True
            Gsats = np.array(Gsats)
            Gtmp = np.full((len(Gsats),8), np.nan)
            Gdt = [to_datetime(line[1:].split())]
        elif isdata and line.startswith('*'):
            Gdata.append(Gtmp.copy())
            Gdt.append(to_datetime(line[1:].split()))
        elif isdata and line.startswith('P'):
            Gtmp[Gsats==line[1:4],:4] = np.array([line[x:x+14] for x in range(4,60,14)]).astype('float')
        elif isdata and line.startswith('V'):
            Gtmp[Gsats==line[1:4],4:] = np.array([line[x:x+14] for x in range(4,60,14)]).astype('float')
        elif isdata and line.startswith('EOF'):
            Gdata.append(Gtmp.copy())
            break
    Gdt = np.array(Gdt)
    Gdata = np.array(Gdata)
    Gdata[np.abs(Gdata - 1E6) < 1E-3] = np.nan
    return Gdata, Gdt, Gsats
