/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.actions.localview.LocalViewEdgeSelectorActionGroup;
import com.intellij.openapi.graph.builder.actions.localview.LocalViewNodeSelectorActionGroup;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.components.CustomGraphBuilderWheelListener;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.util.GraphCopier;
import com.intellij.openapi.graph.view.BaseGraphViewControllerMode;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphViewControllerBuilder;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.LocalViewCreator;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BaseGraphStructureViewBuilder<N, E>
implements StructureViewBuilder {
    @NotNull
    private static final Key<Boolean> LOCAL_VIEW_KEY = Key.create((String)"com.intellij.openapi.graph.builder.components.BasicGraphStructureViewBuilder.LOCAL_VIEW_CLIENT_PROPERTY");
    @NotNull
    private static final Key<Boolean> COMPACT_NODE_DISPLAY_MODE_KEY = Key.create((String)"com.intellij.openapi.graph.builder.components.BasicGraphStructureViewBuilder.COMPACT_NODE_DISPLAY_MODE_KEY");
    @NotNull
    public static final StructureViewModel OUR_DUMMY_MODEL = new DummyStructureViewModel();
    @NotNull
    protected static final JBColor OUR_OVERVIEW_FOG_COLOR = new JBColor(new Color(0, 0, 0, 20), new Color(255, 255, 255, 25));
    @NotNull
    private final GraphBuilder<N, E> myModelBuilder;
    @NotNull
    private final GraphBuilder<N, E> myLocalViewBuilder;
    @NotNull
    private volatile LocalViewCreator.AbstractLocalViewCreator myNodeLocalViewCreator;
    @NotNull
    private volatile LocalViewCreator.AbstractLocalViewCreator myEdgeLocalViewCreator;
    @NotNull
    private volatile LocalViewCreator.AbstractLocalViewCreator myCurrentLocalViewCreator;
    @NotNull
    private final SimpleModificationTracker myModTrackerOfViewUpdates;
    @NotNull
    private final Overview myOverview;
    @NotNull
    private final JBSplitter myComponent;

    public BaseGraphStructureViewBuilder(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(0);
        }
        this.myModTrackerOfViewUpdates = new SimpleModificationTracker();
        this.myModelBuilder = modelBuilder;
        this.myOverview = this.createOverview(modelBuilder);
        Graph2D modelGraph = modelBuilder.getGraph();
        GraphCopier.CopyFactory copyFactory = modelGraph.getGraphCopyFactory();
        Graph2D localViewGraph = (Graph2D)copyFactory.createGraph();
        Graph2DView localView = this.createLocalView(modelBuilder, localViewGraph);
        this.myNodeLocalViewCreator = this.createInitialNodeLocalViewCreator(modelGraph, copyFactory, localViewGraph);
        this.myEdgeLocalViewCreator = this.createInitialEdgeLocalViewCreator(modelGraph, copyFactory, localViewGraph);
        this.myCurrentLocalViewCreator = this.myNodeLocalViewCreator;
        EditMode editModeForLocalView = this.createEditModeForLocalView(modelBuilder);
        this.myLocalViewBuilder = this.createAndSetupLocalViewBuilder(modelBuilder.getProject(), localViewGraph, localView, editModeForLocalView);
        this.setupViewControllers(editModeForLocalView);
        this.myComponent = this.createDividedPane(this.myOverview.getJComponent(), localView.getJComponent());
        this.updateSplitterOrientation();
        this.updateColors(localView, modelBuilder.getView());
    }

    @NotNull
    protected GraphBuilder<N, E> createAndSetupLocalViewBuilder(@NotNull Project project, @NotNull Graph2D localViewGraph, @NotNull Graph2DView localView, @NotNull EditMode editModeForLocalView) {
        if (project == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(1);
        }
        if (localViewGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(2);
        }
        if (localView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(3);
        }
        if (editModeForLocalView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(4);
        }
        LocalViewGraphDataModel dataModel = new LocalViewGraphDataModel();
        LocalViewGraphPresentationModel presentationModel = new LocalViewGraphPresentationModel(localViewGraph);
        GraphBuilder localViewBuilder = GraphBuilderFactory.getInstance(project).createGraphBuilder(localViewGraph, localView, dataModel, presentationModel, editModeForLocalView);
        presentationModel.setGraphBuilder(localViewBuilder);
        localViewBuilder.initialize();
        localViewBuilder.putUserData(LOCAL_VIEW_KEY, true);
        localViewBuilder.putUserData(COMPACT_NODE_DISPLAY_MODE_KEY, true);
        localViewBuilder.putUserData((Key)GraphDataKeys.MODEL_GRAPH_BUILDER, this.getModelBuilder());
        GraphAnimationService.getInstance().setZoomAnimationEnabledFor(localViewBuilder, false);
        this.setupModelUpdateOnBuilderUpdateFor(localViewBuilder);
        GraphBuilder graphBuilder = localViewBuilder;
        if (graphBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(5);
        }
        return graphBuilder;
    }

    @NotNull
    public StructureView createStructureView(@Nullable FileEditor fileEditor, @NotNull Project project) {
        if (project == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(6);
        }
        return new BasicGraphStructureView();
    }

    @RequiresEdt
    @NotNull
    protected Overview createOverview(final @NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Overview overview = GraphManager.getGraphManager().createOverview(modelBuilder.getView());
        this.setupBackgroundRenderer(overview);
        overview.getJComponent().putClientProperty("Overview.FogColor", OUR_OVERVIEW_FOG_COLOR);
        overview.getJComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                modelBuilder.getView().requestFocus();
            }
        });
        Overview overview2 = overview;
        if (overview2 == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(8);
        }
        return overview2;
    }

    protected void setupBackgroundRenderer(@NotNull Graph2DView view) {
        if (view == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(9);
        }
        DefaultBackgroundRenderer renderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        renderer.setColor(UIUtil.getListBackground());
        view.setBackgroundRenderer(renderer);
    }

    @NotNull
    protected LocalViewCreator.AbstractLocalViewCreator createInitialNodeLocalViewCreator(@NotNull Graph2D modelGraph, @NotNull GraphCopier.CopyFactory copyFactory, @NotNull Graph2D localViewGraph) {
        if (modelGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(10);
        }
        if (copyFactory == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(11);
        }
        if (localViewGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(12);
        }
        LocalViewCreator.Neighborhood localViewCreator = GraphManager.getGraphManager().createLocalViewCreator_Neighborhood(modelGraph, copyFactory, localViewGraph);
        localViewCreator.setNeighborhoodType(LocalViewCreator.Neighborhood.NEIGHBORHOOD_TYPE_NEIGHBORS);
        localViewCreator.setEdgePolicy(LocalViewCreator.Neighborhood.EDGE_POLICY_INDUCED_SUBGRAPH);
        localViewCreator.setName(GraphBundle.message("graph.localview.show.for.node.neighbourhood", new Object[0]));
        LocalViewCreator.Neighborhood neighborhood = localViewCreator;
        if (neighborhood == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(13);
        }
        return neighborhood;
    }

    @NotNull
    protected LocalViewCreator.AbstractLocalViewCreator createInitialEdgeLocalViewCreator(@NotNull Graph2D modelGraph, @NotNull GraphCopier.CopyFactory copyFactory, @NotNull Graph2D localViewGraph) {
        if (modelGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(14);
        }
        if (copyFactory == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(15);
        }
        if (localViewGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(16);
        }
        LocalViewCreator.EdgeGroup localViewCreator = GraphManager.getGraphManager().createLocalViewCreator_EdgeGroup(modelGraph, copyFactory, localViewGraph);
        localViewCreator.setGroupByPolicy(LocalViewCreator.EdgeGroup.GROUP_BY_SOURCE_OR_TARGET);
        localViewCreator.setName(GraphBundle.message("graph.localview.show.for.edge.group.by.source.or.target", new Object[0]));
        LocalViewCreator.EdgeGroup edgeGroup = localViewCreator;
        if (edgeGroup == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(17);
        }
        return edgeGroup;
    }

    @NotNull
    protected Graph2DView createLocalView(@NotNull GraphBuilder<N, E> modelBuilder, @NotNull Graph2D localViewGraph) {
        if (modelBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(18);
        }
        if (localViewGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(19);
        }
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(localViewGraph);
        this.setupBackgroundRenderer(view);
        view.setFitContentOnResize(true);
        view.setScrollBarPolicy(21, 31);
        Graph2DView graph2DView = view;
        if (graph2DView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(20);
        }
        return graph2DView;
    }

    protected void updateColors(@NotNull Graph2DView localView, @NotNull Graph2DView modelView) {
        if (localView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(21);
        }
        if (modelView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(22);
        }
        localView.setGridColor(modelView.getGridColor());
        localView.setCoarseGridColor(modelView.getCoarseGridColor());
        BaseGraphStructureViewBuilder.copyClientProperty(modelView.getJComponent(), localView.getJComponent(), "selectionbox.fillcolor");
        BaseGraphStructureViewBuilder.copyClientProperty(modelView.getJComponent(), localView.getJComponent(), "selectionbox.linecolor");
        BaseGraphStructureViewBuilder.copyClientProperty(modelView.getJComponent(), localView.getJComponent(), "magnifier.linecolor");
    }

    @NotNull
    protected EditMode createEditModeForLocalView(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(23);
        }
        EditMode editMode = GraphEditModeFactory.getInstance(modelBuilder.getProject()).createEditMode(modelBuilder);
        editMode.allowNodeCreation(false);
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.allowNodeEditing(false);
        editMode.allowResizeNodes(false);
        editMode.allowMoveLabels(false);
        editMode.allowMovePorts(false);
        editMode.allowLabelSelection(false);
        editMode.allowMoveSelection(false);
        editMode.allowMoving(false);
        editMode.allowMovingWithPopup(true);
        editMode.setAdjustScrollBarPolicy(false);
        editMode.showEdgeTips(true);
        editMode.showNodeTips(true);
        EditMode editMode2 = editMode;
        if (editMode2 == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(24);
        }
        return editMode2;
    }

    private void setupModelUpdateOnBuilderUpdateFor(@NotNull GraphBuilder<N, E> localViewBuilder) {
        if (localViewBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(25);
        }
        localViewBuilder.addCustomUpdater(new CustomGraphUpdater(){
            boolean myRecursionGuardCheck = false;

            @Override
            public void update(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull Collection<?> nodesForSizeUpdate) {
                if (graph == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (view == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (nodesForSizeUpdate == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!this.myRecursionGuardCheck) {
                    this.myRecursionGuardCheck = true;
                    BaseGraphStructureViewBuilder.this.myModTrackerOfViewUpdates.incModificationCount();
                    BaseGraphStructureViewBuilder.this.updateLocalViewGraph();
                }
                this.myRecursionGuardCheck = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "graph";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "view";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "nodesForSizeUpdate";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$2";
                objectArray[2] = "update";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @RequiresEdt
    protected void setupViewControllers(@NotNull EditMode editMode) {
        if (editMode == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.assertEventDispatchThread();
        MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
        magnifierViewMode.setMagnifierRadius(170);
        ((LocalGraphViewControllerBuilder)((LocalGraphViewControllerBuilder)((LocalGraphViewControllerBuilder)LocalGraphViewControllerBuilder.beginSetupFor(this, this.myLocalViewBuilder).setEditMode(editMode)).setMagnifierViewMode(magnifierViewMode)).setSelectionBoxMode(null)).endSetup();
    }

    @RequiresEdt
    @NotNull
    protected JBSplitter createDividedPane(@NotNull JComponent first, @NotNull JComponent second) {
        if (first == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(27);
        }
        if (second == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(28);
        }
        ThreadingAssertions.assertEventDispatchThread();
        OnePixelSplitter pane = new OnePixelSplitter(0.5f);
        pane.setFirstComponent(first);
        pane.setSecondComponent(second);
        OnePixelSplitter onePixelSplitter = pane;
        if (onePixelSplitter == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(29);
        }
        return onePixelSplitter;
    }

    public void updateSplitterOrientation() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myModelBuilder.getProject()).getToolWindow("Structure");
        if (toolWindow != null) {
            this.myComponent.setOrientation(!toolWindow.getAnchor().isHorizontal());
        }
    }

    @NotNull
    public Graph2DSelectionListener createModelSelectionTrigger() {
        return new SelectionTrigger();
    }

    @NotNull
    public GraphBuilder<N, E> getModelBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myModelBuilder;
        if (graphBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(30);
        }
        return graphBuilder;
    }

    @NotNull
    public GraphBuilder<N, E> getLocalViewBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myLocalViewBuilder;
        if (graphBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(31);
        }
        return graphBuilder;
    }

    @NotNull
    protected Optional<N> getModelGraphNodeObject(@Nullable Node node) {
        Optional<Object> optional = Optional.ofNullable(node).map(it -> this.getCurrentLocalViewCreator().getModelNode((Node)it)).map(it -> this.getModelBuilder().getNodeObject((Node)it));
        if (optional == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(32);
        }
        return optional;
    }

    @NotNull
    protected Optional<E> getModelGraphEdgeObject(@Nullable Edge edge) {
        Optional<Object> optional = Optional.ofNullable(edge).map(it -> this.getCurrentLocalViewCreator().getModelEdge((Edge)it)).map(it -> this.getModelBuilder().getEdgeObject((Edge)it));
        if (optional == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(33);
        }
        return optional;
    }

    @NotNull
    public Overview getOverview() {
        Overview overview = this.myOverview;
        if (overview == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(34);
        }
        return overview;
    }

    @NotNull
    public JComponent getComponent() {
        JBSplitter jBSplitter = this.myComponent;
        if (jBSplitter == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(35);
        }
        return jBSplitter;
    }

    @NotNull
    public Graph2DView getLocalView() {
        Graph2DView graph2DView = this.myLocalViewBuilder.getView();
        if (graph2DView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(36);
        }
        return graph2DView;
    }

    @NotNull
    public LocalViewCreator.AbstractLocalViewCreator getCurrentLocalViewCreator() {
        LocalViewCreator.AbstractLocalViewCreator abstractLocalViewCreator = this.myCurrentLocalViewCreator;
        if (abstractLocalViewCreator == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(37);
        }
        return abstractLocalViewCreator;
    }

    protected void updateLocalViewBuilder() {
        this.getLocalViewBuilder().queryGraphUpdate().withDataReload().withAllNodeSizeUpdateIf(BaseGraphStructureViewBuilder.isCompactNodeDisplayModeEnabledFor(this.myLocalViewBuilder)).withRelayout().run();
    }

    private void updateLocalViewGraph() {
        this.myCurrentLocalViewCreator.updateViewGraph();
        Map<Object, Node> modelNode2Node = Arrays.stream(this.myCurrentLocalViewCreator.getViewGraph().getNodeArray()).map(it -> Pair.create(this.getModelGraphNodeObject((Node)it).orElseThrow(), (Object)it)).collect(Collectors.toMap(it -> it.first, it -> (Node)it.second));
        Map<Object, Edge> modelEdge2Edge = Arrays.stream(this.myCurrentLocalViewCreator.getViewGraph().getEdgeArray()).map(it -> Pair.create(this.getModelGraphEdgeObject((Edge)it).orElseThrow(), (Object)it)).collect(Collectors.toMap(it -> it.first, it -> (Edge)it.second));
        this.myLocalViewBuilder.updateDataModelWithCustomMapping(modelNode2Node::get, modelEdge2Edge::get);
        this.myLocalViewBuilder.queryGraphUpdate().withAllNodeSizeUpdateIf(BaseGraphStructureViewBuilder.isCompactNodeDisplayModeEnabledFor(this.myLocalViewBuilder)).withRelayout().run();
    }

    protected void updateViewOfSelectedNodes(@NotNull List<Node> nodes) {
        if (nodes == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(38);
        }
        this.myCurrentLocalViewCreator = this.myNodeLocalViewCreator;
        this.myCurrentLocalViewCreator.clearFocusNodes();
        for (Node node : nodes) {
            this.myCurrentLocalViewCreator.addFocusNode(node);
        }
        this.updateLocalViewBuilder();
    }

    protected void updateViewOfSelectedEdges(@NotNull List<Edge> edges) {
        if (edges == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(39);
        }
        this.myCurrentLocalViewCreator = this.myEdgeLocalViewCreator;
        this.myCurrentLocalViewCreator.clearFocusEdges();
        for (Edge edge : edges) {
            this.myCurrentLocalViewCreator.addFocusEdge(edge);
        }
        this.updateLocalViewBuilder();
    }

    private static void copyClientProperty(@NotNull JComponent source, @NotNull JComponent target, @NotNull String key) {
        if (source == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(40);
        }
        if (target == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(41);
        }
        if (key == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(42);
        }
        target.putClientProperty(key, source.getClientProperty(key));
    }

    public static boolean isLocalViewBuilder(@NotNull GraphBuilder<?, ?> builder2) {
        if (builder2 == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(43);
        }
        return builder2.getUserData(LOCAL_VIEW_KEY) == Boolean.TRUE;
    }

    @Nullable
    public static GraphBuilder<?, ?> getModelBuilderForLocalViewBuilder(@NotNull GraphBuilder<?, ?> localViewBuilder) {
        if (localViewBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(44);
        }
        return (GraphBuilder)((Object)localViewBuilder.getUserData(GraphDataKeys.MODEL_GRAPH_BUILDER));
    }

    public static boolean isCompactNodeDisplayModeEnabledFor(@NotNull GraphBuilder<?, ?> localViewBuilder) {
        if (localViewBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(45);
        }
        return localViewBuilder.getUserData(COMPACT_NODE_DISPLAY_MODE_KEY) == Boolean.TRUE;
    }

    public static void setCompactNodeDisplayModeEnabledFor(@NotNull GraphBuilder<?, ?> localViewBuilder, boolean state) {
        if (localViewBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(46);
        }
        localViewBuilder.putUserData(COMPACT_NODE_DISPLAY_MODE_KEY, state);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 13, 17, 20, 24, 29, 30, 31, 32, 33, 34, 35, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuilder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localViewGraph";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editModeForLocalView";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelGraph";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFactory";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelView";
                break;
            }
            case 25: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localViewBuilder";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndSetupLocalViewBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverview";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialNodeLocalViewCreator";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialEdgeLocalViewCreator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalView";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditModeForLocalView";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createDividedPane";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalViewBuilder";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphNodeObject";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphEdgeObject";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverview";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalView";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLocalViewCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAndSetupLocalViewBuilder";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStructureView";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOverview";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupBackgroundRenderer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createInitialNodeLocalViewCreator";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInitialEdgeLocalViewCreator";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLocalView";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEditModeForLocalView";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setupModelUpdateOnBuilderUpdateFor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupViewControllers";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDividedPane";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateViewOfSelectedNodes";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateViewOfSelectedEdges";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyClientProperty";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isLocalViewBuilder";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilderForLocalViewBuilder";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isCompactNodeDisplayModeEnabledFor";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setCompactNodeDisplayModeEnabledFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 13, 17, 20, 24, 29, 30, 31, 32, 33, 34, 35, 36, 37 -> new IllegalStateException(string);
        };
    }

    public class LocalViewGraphDataModel
    extends GraphDataModel<N, E> {
        @Override
        public @Unmodifiable @NotNull Collection<N> getNodes() {
            List list = ContainerUtil.mapNotNull((Object[])BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getViewGraph().getNodeArray(), it -> BaseGraphStructureViewBuilder.this.getModelGraphNodeObject((Node)it).orElse(null));
            if (list == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public @Unmodifiable @NotNull Collection<E> getEdges() {
            List list = ContainerUtil.mapNotNull((Object[])BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getViewGraph().getEdgeArray(), it -> BaseGraphStructureViewBuilder.this.getModelGraphEdgeObject((Edge)it).orElse(null));
            if (list == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public N getSourceNode(E edge) {
            Object n = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphDataModel().getSourceNode(edge);
            if (n == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(2);
            }
            return n;
        }

        @Override
        @NotNull
        public N getTargetNode(E edge) {
            Object n = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphDataModel().getTargetNode(edge);
            if (n == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(3);
            }
            return n;
        }

        @Override
        @NotNull
        public String getNodeName(N node) {
            String string = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphDataModel().getNodeName(node);
            if (string == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getEdgeName(E edge) {
            String string = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphDataModel().getEdgeName(edge);
            if (string == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @Nullable
        public E createEdge(@NotNull N from, @NotNull N to) {
            if (from == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(6);
            }
            if (to == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(7);
            }
            return null;
        }

        public void dispose() {
        }

        @NotNull
        public List<LocalViewCreator.AbstractLocalViewCreator> getSupportedNodeLocalViewCreators() {
            Graph2D modelGraph = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraph();
            GraphCopier.CopyFactory copyFactory = modelGraph.getGraphCopyFactory();
            Graph2D localViewGraph = BaseGraphStructureViewBuilder.this.getLocalViewBuilder().getGraph();
            GraphManager graphManager = GraphManager.getGraphManager();
            LocalViewCreator.Neighborhood neighbourhoodView = graphManager.createLocalViewCreator_Neighborhood(modelGraph, copyFactory, localViewGraph);
            neighbourhoodView.setNeighborhoodType(LocalViewCreator.Neighborhood.NEIGHBORHOOD_TYPE_NEIGHBORS);
            neighbourhoodView.setEdgePolicy(LocalViewCreator.Neighborhood.EDGE_POLICY_INDUCED_SUBGRAPH);
            neighbourhoodView.setName(GraphBundle.message("graph.localview.show.for.node.neighbourhood", new Object[0]));
            LocalViewCreator.Neighborhood successorsView = graphManager.createLocalViewCreator_Neighborhood(modelGraph, copyFactory, localViewGraph);
            successorsView.setNeighborhoodType(LocalViewCreator.Neighborhood.NEIGHBORHOOD_TYPE_SUCCESSORS);
            successorsView.setEdgePolicy(LocalViewCreator.Neighborhood.EDGE_POLICY_INDUCED_SUBGRAPH);
            successorsView.setName(GraphBundle.message("graph.localview.show.for.node.successors", new Object[0]));
            LocalViewCreator.Neighborhood predecessorsView = graphManager.createLocalViewCreator_Neighborhood(modelGraph, copyFactory, localViewGraph);
            predecessorsView.setNeighborhoodType(LocalViewCreator.Neighborhood.NEIGHBORHOOD_TYPE_PREDECESSORS);
            predecessorsView.setEdgePolicy(LocalViewCreator.Neighborhood.EDGE_POLICY_INDUCED_SUBGRAPH);
            predecessorsView.setName(GraphBundle.message("graph.localview.show.for.node.predecessors", new Object[0]));
            List<LocalViewCreator.AbstractLocalViewCreator> list = List.of(neighbourhoodView, successorsView, predecessorsView);
            if (list == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public List<LocalViewCreator.AbstractLocalViewCreator> getSupportedEdgeLocalViewCreators() {
            Graph2D modelGraph = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraph();
            GraphCopier.CopyFactory copyFactory = modelGraph.getGraphCopyFactory();
            Graph2D localViewGraph = BaseGraphStructureViewBuilder.this.getLocalViewBuilder().getGraph();
            GraphManager graphManager = GraphManager.getGraphManager();
            LocalViewCreator.EdgeGroup edgeGroupBySourceView = graphManager.createLocalViewCreator_EdgeGroup(modelGraph, copyFactory, localViewGraph);
            edgeGroupBySourceView.setGroupByPolicy(LocalViewCreator.EdgeGroup.GROUP_BY_SOURCE);
            edgeGroupBySourceView.setName(GraphBundle.message("graph.localview.show.for.edge.group.by.source", new Object[0]));
            LocalViewCreator.EdgeGroup edgeGroupByTargetView = graphManager.createLocalViewCreator_EdgeGroup(modelGraph, copyFactory, localViewGraph);
            edgeGroupByTargetView.setGroupByPolicy(LocalViewCreator.EdgeGroup.GROUP_BY_TARGET);
            edgeGroupByTargetView.setName(GraphBundle.message("graph.localview.show.for.edge.group.by.target", new Object[0]));
            LocalViewCreator.EdgeGroup edgeGroupBySourceOrTargetView = graphManager.createLocalViewCreator_EdgeGroup(modelGraph, copyFactory, localViewGraph);
            edgeGroupBySourceOrTargetView.setGroupByPolicy(LocalViewCreator.EdgeGroup.GROUP_BY_SOURCE_OR_TARGET);
            edgeGroupBySourceOrTargetView.setName(GraphBundle.message("graph.localview.show.for.edge.group.by.source.or.target", new Object[0]));
            LocalViewCreator.EdgeGroup edgeGroupBySourceAndTargetView = graphManager.createLocalViewCreator_EdgeGroup(modelGraph, copyFactory, localViewGraph);
            edgeGroupBySourceAndTargetView.setGroupByPolicy(LocalViewCreator.EdgeGroup.GROUP_BY_SOURCE_AND_TARGET);
            edgeGroupBySourceAndTargetView.setName(GraphBundle.message("graph.localview.show.for.edge.group.by.source.and.target", new Object[0]));
            LocalViewCreator.SourceAndTarget sourceAndTargetView = graphManager.createLocalViewCreator_SourceAndTarget(modelGraph, copyFactory, localViewGraph);
            sourceAndTargetView.setName(GraphBundle.message("graph.localview.show.for.edge.source.and.target", new Object[0]));
            List<LocalViewCreator.AbstractLocalViewCreator> list = List.of(edgeGroupBySourceView, edgeGroupByTargetView, edgeGroupBySourceOrTargetView, edgeGroupBySourceAndTargetView, sourceAndTargetView);
            if (list == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public LocalViewCreator.AbstractLocalViewCreator getCurrentNodeLocalViewCreator() {
            LocalViewCreator.AbstractLocalViewCreator abstractLocalViewCreator = BaseGraphStructureViewBuilder.this.myNodeLocalViewCreator;
            if (abstractLocalViewCreator == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(10);
            }
            return abstractLocalViewCreator;
        }

        public void setCurrentNodeLocalViewCreator(@NotNull LocalViewCreator.AbstractLocalViewCreator nodeLocalViewCreator) {
            if (nodeLocalViewCreator == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(11);
            }
            BaseGraphStructureViewBuilder.this.myNodeLocalViewCreator = BaseGraphStructureViewBuilder.this.myCurrentLocalViewCreator = nodeLocalViewCreator;
        }

        @NotNull
        public LocalViewCreator.AbstractLocalViewCreator getCurrentEdgeLocalViewCreator() {
            LocalViewCreator.AbstractLocalViewCreator abstractLocalViewCreator = BaseGraphStructureViewBuilder.this.myEdgeLocalViewCreator;
            if (abstractLocalViewCreator == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(12);
            }
            return abstractLocalViewCreator;
        }

        public void setCurrentEdgeLocalViewCreator(@NotNull LocalViewCreator.AbstractLocalViewCreator edgeLocalViewCreator) {
            if (edgeLocalViewCreator == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(13);
            }
            BaseGraphStructureViewBuilder.this.myEdgeLocalViewCreator = BaseGraphStructureViewBuilder.this.myCurrentLocalViewCreator = edgeLocalViewCreator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 6, 7, 11, 13 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphDataModel";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeLocalViewCreator";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeLocalViewCreator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeName";
                    break;
                }
                case 6: 
                case 7: 
                case 11: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphDataModel";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedNodeLocalViewCreators";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedEdgeLocalViewCreators";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentNodeLocalViewCreator";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentEdgeLocalViewCreator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createEdge";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setCurrentNodeLocalViewCreator";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setCurrentEdgeLocalViewCreator";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 6, 7, 11, 13 -> new IllegalArgumentException(string);
            };
        }
    }

    protected final class LocalViewGraphPresentationModel
    extends BasicGraphPresentationModel<N, E> {
        public LocalViewGraphPresentationModel(Graph graph) {
            if (graph == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(0);
            }
            super(graph);
        }

        @Override
        @NotNull
        public NodeRealizer getNodeRealizer(@Nullable N node) {
            NodeRealizer nodeRealizer = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphPresentationModel().getNodeRealizer(BaseGraphStructureViewBuilder.this.getLocalViewBuilder(), node);
            if (nodeRealizer == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(1);
            }
            return nodeRealizer;
        }

        @Override
        @NotNull
        public EdgeRealizer getEdgeRealizer(@Nullable E edge) {
            EdgeRealizer edgeRealizer = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphPresentationModel().getEdgeRealizer(this.getSettings().getCurrentEdgeRealizerProvider(), edge);
            if (edgeRealizer == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(2);
            }
            return edgeRealizer;
        }

        @Override
        @Nullable
        public String getNodeTooltip(@Nullable N node) {
            return BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphPresentationModel().getNodeTooltip(node);
        }

        @Override
        @Nullable
        public String getEdgeTooltip(@Nullable E edge) {
            return BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphPresentationModel().getEdgeTooltip(edge);
        }

        @Override
        @NotNull
        protected DefaultActionGroup getCommonActionGroup() {
            DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Graph.NeighborhoodViewPopup")});
            group.add((AnAction)Separator.create(), new Constraints(Anchor.FIRST, null));
            group.add((AnAction)this.createSelectorChoiceGroup(), new Constraints(Anchor.FIRST, null));
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(3);
            }
            return defaultActionGroup;
        }

        @NotNull
        private DefaultActionGroup createSelectorChoiceGroup() {
            DefaultActionGroup group = new DefaultActionGroup(GraphBundle.message("graph.localview.show", new Object[0]), true);
            group.add((AnAction)new LocalViewNodeSelectorActionGroup(BaseGraphStructureViewBuilder.this.getLocalViewBuilder()));
            group.add((AnAction)new LocalViewEdgeSelectorActionGroup(BaseGraphStructureViewBuilder.this.getLocalViewBuilder()));
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(4);
            }
            return defaultActionGroup;
        }

        @Override
        public EdgeLabel @NotNull [] getEdgeLabels(@Nullable E edge, @NotNull String edgeName) {
            if (edgeName == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(5);
            }
            EdgeLabel[] edgeLabelArray = BaseGraphStructureViewBuilder.this.getModelBuilder().getGraphPresentationModel().getEdgeLabels(edge, edgeName);
            if (edgeLabelArray == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(6);
            }
            return edgeLabelArray;
        }

        @Override
        public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
            if (view == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(7);
            }
            if (editMode == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(8);
            }
            super.customizeSettings(view, editMode);
            view.setGridVisible(false);
            this.getSettings().setShowGrid(false);
            this.getSettings().setMergeEdgeBySources(false);
            this.getSettings().setMergeEdgeByTargets(false);
        }

        @Override
        @Nullable
        public DeleteProvider<N, E> getDeleteProvider() {
            return null;
        }

        @Override
        @NotNull
        public String getActionPlace() {
            return "StructureViewPopup";
        }

        @Override
        public void dispose() {
        }

        @Override
        @NotNull
        public ModificationTracker getModificationTrackerOfViewUpdates() {
            SimpleModificationTracker simpleModificationTracker = BaseGraphStructureViewBuilder.this.myModTrackerOfViewUpdates;
            if (simpleModificationTracker == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(9);
            }
            return simpleModificationTracker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphPresentationModel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphPresentationModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeRealizer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeRealizer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonActionGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSelectorChoiceGroup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeLabels";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModificationTrackerOfViewUpdates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getEdgeLabels";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeSettings";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 6, 9 -> new IllegalStateException(string);
            };
        }
    }

    protected final class BasicGraphStructureView
    implements StructureView {
        private BasicGraphStructureView() {
        }

        public boolean navigateToSelectedElement(boolean requestFocus) {
            return false;
        }

        @NotNull
        public JComponent getComponent() {
            JBSplitter jBSplitter = BaseGraphStructureViewBuilder.this.myComponent;
            if (jBSplitter == null) {
                BasicGraphStructureView.$$$reportNull$$$0(0);
            }
            return jBSplitter;
        }

        public void centerSelectedRow() {
        }

        public void restoreState() {
        }

        public void storeState() {
        }

        @NotNull
        public StructureViewModel getTreeModel() {
            StructureViewModel structureViewModel = OUR_DUMMY_MODEL;
            if (structureViewModel == null) {
                BasicGraphStructureView.$$$reportNull$$$0(1);
            }
            return structureViewModel;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$BasicGraphStructureView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreeModel";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected static final class LocalGraphViewControllerBuilder<N, E>
    extends GraphViewControllerBuilder<LocalGraphViewControllerBuilder<N, E>> {
        @NotNull
        private final BaseGraphStructureViewBuilder<N, E> myStructureViewBuilder;

        private LocalGraphViewControllerBuilder(@NotNull BaseGraphStructureViewBuilder<N, E> structureViewBuilder, @NotNull GraphBuilder<N, E> localViewBuilder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher) {
            if (structureViewBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(0);
            }
            if (localViewBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(1);
            }
            if (dispatcher == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(2);
            }
            super(localViewBuilder, dispatcher);
            this.myStructureViewBuilder = structureViewBuilder;
        }

        @Override
        @NotNull
        protected LocalGraphViewControllerBuilder<N, E> self() {
            LocalGraphViewControllerBuilder localGraphViewControllerBuilder = this;
            if (localGraphViewControllerBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(3);
            }
            return localGraphViewControllerBuilder;
        }

        @Override
        @NotNull
        protected GraphBuilder<N, E> getBuilder() {
            GraphBuilder<?, ?> graphBuilder = super.getBuilder();
            if (graphBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(4);
            }
            return graphBuilder;
        }

        @NotNull
        public static <N, E> LocalGraphViewControllerBuilder<N, E> beginSetupFor(@NotNull BaseGraphStructureViewBuilder<N, E> structureViewBuilder, @NotNull GraphBuilder<N, E> graphBuilder) {
            if (structureViewBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(5);
            }
            if (graphBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(6);
            }
            return new LocalGraphViewControllerBuilder<N, E>(structureViewBuilder, graphBuilder, (EventDispatcher<GraphBuilderListener>)EventDispatcher.create(GraphBuilderListener.class));
        }

        @Override
        public void endSetup() {
            this.setEditModeConstituents(this.getEditMode());
            Graph2DView view = this.getBuilder().getView();
            JComponent canvas = view.getCanvasComponent();
            BaseGraphStructureViewBuilder<N, E> baseGraphStructureViewBuilder = this.myStructureViewBuilder;
            Objects.requireNonNull(baseGraphStructureViewBuilder);
            LocalViewControllerMode controllerMode = baseGraphStructureViewBuilder.new LocalViewControllerMode(this.getBuilder(), this.getDispatcher(), this.getEditMode(), this.getNavigationMode(), this.getMagnifierViewMode());
            view.addViewMode(controllerMode);
            controllerMode.setupKeyBindingsTo(canvas);
            canvas.addFocusListener(controllerMode);
            canvas.addMouseWheelListener(new CustomGraphBuilderWheelListener(this.getBuilder()));
            controllerMode.initialize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structureViewBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localViewBuilder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalGraphViewControllerBuilder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalGraphViewControllerBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "self";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "beginSetupFor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public final class SelectionTrigger
    implements Graph2DSelectionListener {
        @NotNull
        private final Timer myTimer;
        @Nullable
        private Graph2DSelectionEvent myLastEvent;
        private static final int TIMER_DELAY = 100;

        public SelectionTrigger() {
            this.myTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (SelectionTrigger.this.myLastEvent != null) {
                        this.handleEvent(SelectionTrigger.this.myLastEvent);
                    }
                }

                private void handleEvent(@NotNull Graph2DSelectionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (e.isNodeSelection()) {
                        BaseGraphStructureViewBuilder.this.updateViewOfSelectedNodes(GraphSelectionService.getInstance().getSelectedNodes(e.getGraph2D()));
                    } else if (e.isEdgeSelection()) {
                        BaseGraphStructureViewBuilder.this.updateViewOfSelectedEdges(GraphSelectionService.getInstance().getSelectedEdges(e.getGraph2D()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$SelectionTrigger$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleEvent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myTimer.setRepeats(false);
        }

        @Override
        public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent e) {
            if (e == null) {
                SelectionTrigger.$$$reportNull$$$0(0);
            }
            if (GraphManager.getGraphManager().arePhysicalyEqual(e.getGraph2D(), BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getModel()) && (e.isNodeSelection() || e.isEdgeSelection())) {
                this.myLastEvent = e;
                this.myTimer.restart();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$SelectionTrigger", "onGraph2DSelectionEvent"));
        }
    }

    protected static final class DummyStructureViewModel
    implements StructureViewModel {
        protected DummyStructureViewModel() {
        }

        @Nullable
        public Object getCurrentEditorElement() {
            return null;
        }

        public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(0);
            }
        }

        public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(1);
            }
        }

        public void addModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(2);
            }
        }

        public void removeModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public StructureViewTreeElement getRoot() {
            return new StructureViewTreeElement(){

                public Object getValue() {
                    return null;
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    throw new UnsupportedOperationException();
                }

                public TreeElement @NotNull [] getChildren() {
                    if (EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$DummyStructureViewModel$1", "getChildren"));
                }
            };
        }

        public void dispose() {
        }

        public boolean shouldEnterElement(Object element) {
            return false;
        }

        public Grouper @NotNull [] getGroupers() {
            if (Grouper.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(4);
            }
            return Grouper.EMPTY_ARRAY;
        }

        public Sorter @NotNull [] getSorters() {
            if (Sorter.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(5);
            }
            return Sorter.EMPTY_ARRAY;
        }

        public Filter @NotNull [] getFilters() {
            if (Filter.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(6);
            }
            return Filter.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelListener";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$DummyStructureViewModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$DummyStructureViewModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorters";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addEditorPositionListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeEditorPositionListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addModelListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeModelListener";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    protected final class LocalViewControllerMode
    extends BaseGraphViewControllerMode {
        LocalViewControllerMode(@NotNull GraphBuilder<N, E> localViewBuilder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher, @NotNull EditMode editMode, @NotNull NavigationMode navigationMode, MagnifierViewMode zoomMode) {
            if (localViewBuilder == null) {
                LocalViewControllerMode.$$$reportNull$$$0(0);
            }
            if (dispatcher == null) {
                LocalViewControllerMode.$$$reportNull$$$0(1);
            }
            if (editMode == null) {
                LocalViewControllerMode.$$$reportNull$$$0(2);
            }
            if (navigationMode == null) {
                LocalViewControllerMode.$$$reportNull$$$0(3);
            }
            if (zoomMode == null) {
                LocalViewControllerMode.$$$reportNull$$$0(4);
            }
            super(localViewBuilder, dispatcher, editMode, navigationMode, zoomMode);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent mouseEvent) {
            if (mouseEvent == null) {
                LocalViewControllerMode.$$$reportNull$$$0(5);
            }
            super.mouseClicked(mouseEvent);
            HitInfo hitInfo = this.getHitInfo(mouseEvent);
            Graph2DView modelView = BaseGraphStructureViewBuilder.this.getModelBuilder().getView();
            if (hitInfo.getHitNode() != null) {
                this.onNodeClick(hitInfo, modelView);
            } else if (hitInfo.getHitEdge() != null) {
                this.onEdgeClick(hitInfo, modelView);
            }
        }

        private void onEdgeClick(@NotNull HitInfo hitInfo, @NotNull Graph2DView modelView) {
            if (hitInfo == null) {
                LocalViewControllerMode.$$$reportNull$$$0(6);
            }
            if (modelView == null) {
                LocalViewControllerMode.$$$reportNull$$$0(7);
            }
            Graph2D modelGraph = modelView.getGraph2D();
            Edge modelEdge = BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getModelEdge(hitInfo.getHitEdge());
            if (modelEdge != null && GraphManager.getGraphManager().arePhysicalyEqual(modelEdge.getGraph(), modelGraph)) {
                NodeRealizer snr = modelGraph.getRealizer(modelEdge.source());
                NodeRealizer tnr = modelGraph.getRealizer(modelEdge.target());
                Point2D.Double sCenter = new Point2D.Double(snr.getCenterX(), snr.getCenterY());
                Point2D.Double tCenter = new Point2D.Double(tnr.getCenterX(), tnr.getCenterY());
                double minZoom = Math.min((double)modelView.getJComponent().getWidth() / (snr.getWidth() + tnr.getWidth() + Math.abs(sCenter.x - tCenter.x)), (double)modelView.getJComponent().getHeight() / (snr.getHeight() + tnr.getHeight() + Math.abs(sCenter.y - tCenter.y)));
                GraphAnimationService.getInstance().focusView(modelView, Math.min(modelView.getZoom(), minZoom), new Point2D.Double((sCenter.x + tCenter.x) * 0.5, (sCenter.y + tCenter.y) * 0.5), true);
                modelGraph.unselectAll();
                modelGraph.setSelected(modelEdge, true);
                modelGraph.updateViews();
            }
        }

        private void onNodeClick(@NotNull HitInfo hitInfo, @NotNull Graph2DView modelView) {
            if (hitInfo == null) {
                LocalViewControllerMode.$$$reportNull$$$0(8);
            }
            if (modelView == null) {
                LocalViewControllerMode.$$$reportNull$$$0(9);
            }
            Graph2D modelGraph = modelView.getGraph2D();
            Node modelNode = BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getModelNode(hitInfo.getHitNode());
            if (modelNode != null && GraphManager.getGraphManager().arePhysicalyEqual(modelNode.getGraph(), modelGraph)) {
                modelGraph.unselectAll();
                NodeRealizer nr = modelGraph.getRealizer(modelNode);
                Point2D.Double center = new Point2D.Double(nr.getCenterX(), nr.getCenterY());
                double minZoom = Math.min((double)modelView.getJComponent().getWidth() / (nr.getWidth() + 40.0), (double)modelView.getJComponent().getHeight() / (nr.getHeight() + 40.0));
                GraphAnimationService.getInstance().focusView(modelView, Math.min(minZoom, modelView.getZoom()), center, true);
                modelGraph.setSelected(modelNode, true);
                modelGraph.updateViews();
            }
        }

        @Override
        protected void moveNode(int key) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localViewBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationMode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "zoomMode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hitInfo";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelView";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewControllerMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onEdgeClick";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onNodeClick";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

