/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.Configurable;
import io.ktor.network.sockets.ConnectUtilsJvmKt;
import io.ktor.network.sockets.InetSocketAddress;
import io.ktor.network.sockets.ServerSocket;
import io.ktor.network.sockets.Socket;
import io.ktor.network.sockets.SocketAddress;
import io.ktor.network.sockets.SocketOptions;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J;\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0019\b\u0002\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0086@\u00a2\u0006\u0004\b\u0012\u0010\u0013J?\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0019\b\u0002\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0086@\u00a2\u0006\u0004\b\u0016\u0010\u0013J3\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00172\u0019\b\u0002\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0086@\u00a2\u0006\u0004\b\u0012\u0010\u0019J7\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0019\b\u0002\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0086@\u00a2\u0006\u0004\b\u0016\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lio/ktor/network/sockets/TcpSocketBuilder;", "Lio/ktor/network/sockets/Configurable;", "Lio/ktor/network/sockets/SocketOptions$PeerSocketOptions;", "Lio/ktor/network/selector/SelectorManager;", "selector", "options", "<init>", "(Lio/ktor/network/selector/SelectorManager;Lio/ktor/network/sockets/SocketOptions$PeerSocketOptions;)V", "", "hostname", "", "port", "Lkotlin/Function1;", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "", "Lkotlin/ExtensionFunctionType;", "configure", "Lio/ktor/network/sockets/Socket;", "connect", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/network/sockets/SocketOptions$AcceptorOptions;", "Lio/ktor/network/sockets/ServerSocket;", "bind", "Lio/ktor/network/sockets/SocketAddress;", "remoteAddress", "(Lio/ktor/network/sockets/SocketAddress;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "localAddress", "Lio/ktor/network/selector/SelectorManager;", "Lio/ktor/network/sockets/SocketOptions$PeerSocketOptions;", "getOptions", "()Lio/ktor/network/sockets/SocketOptions$PeerSocketOptions;", "setOptions", "(Lio/ktor/network/sockets/SocketOptions$PeerSocketOptions;)V", "ktor-network"})
public final class TcpSocketBuilder
implements Configurable<TcpSocketBuilder, SocketOptions.PeerSocketOptions> {
    @NotNull
    private final SelectorManager selector;
    @NotNull
    private SocketOptions.PeerSocketOptions options;

    public TcpSocketBuilder(@NotNull SelectorManager selector, @NotNull SocketOptions.PeerSocketOptions options2) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.selector = selector;
        this.options = options2;
    }

    @Override
    @NotNull
    public SocketOptions.PeerSocketOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(@NotNull SocketOptions.PeerSocketOptions peerSocketOptions) {
        Intrinsics.checkNotNullParameter((Object)peerSocketOptions, (String)"<set-?>");
        this.options = peerSocketOptions;
    }

    @Nullable
    public final Object connect(@NotNull String hostname, int port, @NotNull Function1<? super SocketOptions.TCPClientSocketOptions, Unit> configure, @NotNull Continuation<? super Socket> $completion) {
        return this.connect(new InetSocketAddress(hostname, port), configure, $completion);
    }

    public static /* synthetic */ Object connect$default(TcpSocketBuilder tcpSocketBuilder, String string, int n, Function1 function1, Continuation continuation2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function1 = TcpSocketBuilder::connect$lambda$0;
        }
        return tcpSocketBuilder.connect(string, n, (Function1<? super SocketOptions.TCPClientSocketOptions, Unit>)function1, (Continuation<? super Socket>)continuation2);
    }

    @Nullable
    public final Object bind(@NotNull String hostname, int port, @NotNull Function1<? super SocketOptions.AcceptorOptions, Unit> configure, @NotNull Continuation<? super ServerSocket> $completion) {
        return this.bind(new InetSocketAddress(hostname, port), configure, $completion);
    }

    public static /* synthetic */ Object bind$default(TcpSocketBuilder tcpSocketBuilder, String string, int n, Function1 function1, Continuation continuation2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "0.0.0.0";
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            function1 = TcpSocketBuilder::bind$lambda$1;
        }
        return tcpSocketBuilder.bind(string, n, (Function1<? super SocketOptions.AcceptorOptions, Unit>)function1, (Continuation<? super ServerSocket>)continuation2);
    }

    @Nullable
    public final Object connect(@NotNull SocketAddress remoteAddress, @NotNull Function1<? super SocketOptions.TCPClientSocketOptions, Unit> configure, @NotNull Continuation<? super Socket> $completion) {
        SocketOptions.TCPClientSocketOptions tCPClientSocketOptions = this.getOptions().tcpConnect$ktor_network();
        configure.invoke((Object)tCPClientSocketOptions);
        return ConnectUtilsJvmKt.tcpConnect(this.selector, remoteAddress, tCPClientSocketOptions, $completion);
    }

    public static /* synthetic */ Object connect$default(TcpSocketBuilder tcpSocketBuilder, SocketAddress socketAddress, Function1 function1, Continuation continuation2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = TcpSocketBuilder::connect$lambda$2;
        }
        return tcpSocketBuilder.connect(socketAddress, (Function1<? super SocketOptions.TCPClientSocketOptions, Unit>)function1, (Continuation<? super Socket>)continuation2);
    }

    @Nullable
    public final Object bind(@Nullable SocketAddress localAddress, @NotNull Function1<? super SocketOptions.AcceptorOptions, Unit> configure, @NotNull Continuation<? super ServerSocket> $completion) {
        SocketOptions.AcceptorOptions acceptorOptions = this.getOptions().tcpAccept$ktor_network();
        configure.invoke((Object)acceptorOptions);
        return ConnectUtilsJvmKt.tcpBind(this.selector, localAddress, acceptorOptions, $completion);
    }

    public static /* synthetic */ Object bind$default(TcpSocketBuilder tcpSocketBuilder, SocketAddress socketAddress, Function1 function1, Continuation continuation2, int n, Object object) {
        if ((n & 1) != 0) {
            socketAddress = null;
        }
        if ((n & 2) != 0) {
            function1 = TcpSocketBuilder::bind$lambda$3;
        }
        return tcpSocketBuilder.bind(socketAddress, (Function1<? super SocketOptions.AcceptorOptions, Unit>)function1, (Continuation<? super ServerSocket>)continuation2);
    }

    @Override
    @NotNull
    public TcpSocketBuilder configure(@NotNull Function1<? super SocketOptions.PeerSocketOptions, Unit> block) {
        return Configurable.DefaultImpls.configure(this, block);
    }

    private static final Unit connect$lambda$0(SocketOptions.TCPClientSocketOptions tCPClientSocketOptions) {
        Intrinsics.checkNotNullParameter((Object)tCPClientSocketOptions, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$1(SocketOptions.AcceptorOptions acceptorOptions) {
        Intrinsics.checkNotNullParameter((Object)acceptorOptions, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit connect$lambda$2(SocketOptions.TCPClientSocketOptions tCPClientSocketOptions) {
        Intrinsics.checkNotNullParameter((Object)tCPClientSocketOptions, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(SocketOptions.AcceptorOptions acceptorOptions) {
        Intrinsics.checkNotNullParameter((Object)acceptorOptions, (String)"<this>");
        return Unit.INSTANCE;
    }
}

