/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.compose.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.python.docker.PyDockerCommandLinePatcher;
import com.intellij.python.docker.PyDockerProcessUtil;
import com.intellij.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.intellij.python.docker.compose.PyDockerComposeProcessUtil;
import com.intellij.python.remoteInterpreter.PyRemoteInterpreterCommandLineUtil;
import com.intellij.remote.RemoteSdkPropertiesPaths;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMapper;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\r"}, d2={"startDockerComposeProcess", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sdkAdditionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "portBindings", "", "Lcom/intellij/docker/agent/compose/beans/DockerComposePort;", "intellij.python.docker"})
public final class PythonConsoleDockerComposeProcessCreatorKt {
    private static final BaseOSProcessHandler startDockerComposeProcess(Project project, GeneralCommandLine commandLine, PyRemoteSdkAdditionalDataBase sdkAdditionalData, PyRemotePathMapper pathMapper, List<DockerComposePort> portBindings) {
        PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(sdkAdditionalData);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pyDockerComposeProcessConnectionData), (String)"getPyDockerComposeProcessConnectionData(...)");
        PyDockerComposeProcessConnectionData data = pyDockerComposeProcessConnectionData;
        ParamsGroup exeGroup = commandLine.getParametersList().getParamsGroup("Exe Options");
        if (exeGroup != null) {
            PythonRemoteInterpreterManager.addUnbuffered((ParamsGroup)exeGroup);
        }
        PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = data.getPyRemoteSocketToLocalHostProvider();
        Intrinsics.checkNotNullExpressionValue((Object)pyRemoteSocketToLocalHostProvider, (String)"getPyRemoteSocketToLocalHostProvider(...)");
        PyRemoteSocketToLocalHostProvider dockerSocketProvider = pyRemoteSocketToLocalHostProvider;
        PyDockerCommandLinePatcher.patchCommandLineForDocker(commandLine, (RemoteSdkPropertiesPaths)data, dockerSocketProvider, pathMapper);
        PyCommandLineStateUtil.remap((String)data.getInterpreterPath(), (GeneralCommandLine)commandLine, (PathMapper)((PathMapper)pathMapper));
        if (commandLine.getWorkDirectory() != null) {
            commandLine.setWorkDirectory(pathMapper.convertToRemote(commandLine.getWorkDirectory().getPath()));
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)commandLine.getCommandLineList(null));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        String[] command = stringArray;
        String workingDir = commandLine.getWorkDirectory() != null ? commandLine.getWorkDirectory().getPath() : null;
        VolumesBuilder volumesBuilder = PyDockerComposeProcessUtil.setupVolumeBinds(project, null);
        Intrinsics.checkNotNullExpressionValue((Object)volumesBuilder, (String)"setupVolumeBinds(...)");
        VolumesBuilder volumesBinds = volumesBuilder;
        Pair<String[], String> commandWithWorkingDir = PyRemoteInterpreterCommandLineUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, command, workingDir, data.getInterpreterPath());
        Map map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        Map env = MapsKt.toMutableMap((Map)map);
        PythonEnvUtil.setPythonUnbuffered((Map)env);
        try {
            DockerCloudConfiguration dockerCloudConfiguration = data.getAccount();
            Intrinsics.checkNotNullExpressionValue((Object)dockerCloudConfiguration, (String)"getAccount(...)");
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.Companion.create(dockerCloudConfiguration, project);
            SharedVolume sharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
            Intrinsics.checkNotNullExpressionValue((Object)sharedVolume, (String)"getPyCharmHelpersSharedVolume(...)");
            SharedVolume helpersSharedVolume = sharedVolume;
            DockerComposeServiceClient dockerComposeServiceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            Intrinsics.checkNotNullExpressionValue((Object)dockerComposeServiceClient, (String)"getInstance(...)");
            DockerComposeServiceClient serviceClient = dockerComposeServiceClient;
            String[] stringArray2 = (String[])commandWithWorkingDir.getFirst();
            ComposeServiceRunCmd composeServiceRunCmd = ((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withEnvironment(env)).withCommand(Arrays.copyOf(stringArray2, stringArray2.length))).withWorkingDir((String)commandWithWorkingDir.getSecond())).withSharedVolume(helpersSharedVolume)).withPublishPorts(portBindings).withVolumes(PyDockerComposeProcessUtil.removeRepeatedContainerPaths(volumesBinds.build()))).withNoDeps(false).withRemove(true);
            Intrinsics.checkNotNullExpressionValue((Object)composeServiceRunCmd, (String)"withRemove(...)");
            ComposeServiceRunCmd runServiceCmd = composeServiceRunCmd;
            KillableColoredProcessHandler killableColoredProcessHandler = runServiceCmd.execute();
            Intrinsics.checkNotNullExpressionValue((Object)killableColoredProcessHandler, (String)"execute(...)");
            return (BaseOSProcessHandler)killableColoredProcessHandler;
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((ServerRuntimeException)((Object)e)));
        }
        catch (ServerRuntimeException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
    }

    public static final /* synthetic */ BaseOSProcessHandler access$startDockerComposeProcess(Project project, GeneralCommandLine commandLine, PyRemoteSdkAdditionalDataBase sdkAdditionalData, PyRemotePathMapper pathMapper, List portBindings) {
        return PythonConsoleDockerComposeProcessCreatorKt.startDockerComposeProcess(project, commandLine, sdkAdditionalData, pathMapper, portBindings);
    }
}

