/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.coverage;

import com.google.common.collect.Lists;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.pro.coverage.PyCoverageEngine;
import com.intellij.python.pro.coverage.PyCoverageOptionsProvider;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonProcessHandler;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCoverageUtil {
    private static final Logger LOG = Logger.getInstance(PyCoverageEngine.class);

    private PyCoverageUtil() {
    }

    public static void generateReport(final @NotNull Project project, DataContext dataContext, CoverageSuitesBundle currentSuite) {
        if (project == null) {
            PyCoverageUtil.$$$reportNull$$$0(0);
        }
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        final String outputDir = settings.OUTPUT_DIRECTORY;
        final boolean openInBrowser = settings.OPEN_IN_BROWSER;
        final Module module = PyCoverageUtil.getModuleWithPySdk(project);
        if (module == null) {
            Messages.showErrorDialog((Project)project, (String)PythonProBundle.message((String)"python.coverage.module.not.found"), (String)PythonProBundle.message((String)"python.coverage.module.not.found"));
            return;
        }
        final Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module);
        assert (sdk != null);
        final String coverageDataFileName = currentSuite.getSuites()[0].getCoverageDataFileName();
        Task.Modal generateReportTask = new Task.Modal(project, PythonProBundle.message((String)"python.coverage.generating.report"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    GeneralCommandLine cmd = PyCoverageUtil.createCommandLine(module, Lists.newArrayList((Object[])new String[]{"html", "-d", outputDir}));
                    PyCoverageUtil.addCoverageFileEnv(cmd, coverageDataFileName);
                    PyCoverageUtil.addRunCoverageEnv(cmd);
                    if (PyCoverageOptionsProvider.getInstance(project).isUseBundledCoveragePy()) {
                        PyCoverageUtil.addBundledCoverageToPythonPath(sdk, cmd.getEnvironment());
                    }
                    PythonProcessHandler processHandler = new PythonProcessHandler(cmd);
                    ProcessOutput output = new ProcessOutput();
                    processHandler.addProcessListener((ProcessListener)new CapturingProcessAdapter(output));
                    processHandler.startNotify();
                    processHandler.waitFor();
                    output.setExitCode(processHandler.getProcess().exitValue());
                    if (output.getExitCode() == 0) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            File file = new File(outputDir, "index.html");
                            if (!file.exists()) {
                                Object error = PythonProBundle.message((String)"python.coverage.report.no.generated.in", (Object[])new Object[]{output});
                                if (StringUtil.isNotEmpty((String)output.getStdout())) {
                                    error = (String)error + "\n" + output.getStdout();
                                }
                                if (StringUtil.isNotEmpty((String)output.getStderr())) {
                                    error = (String)error + "\n" + output.getStderr();
                                }
                                Messages.showErrorDialog((String)error, (String)PythonProBundle.message((String)"python.coverage.error"));
                            } else if (openInBrowser) {
                                BrowserUtil.browse((File)file);
                            } else {
                                ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)PythonProBundle.message((String)"python.coverage.report.generated.in", (Object[])new Object[]{outputDir}), (String)PythonProBundle.message((String)"python.coverage.report.generated")));
                            }
                        });
                    } else {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)PythonProBundle.message((String)"python.coverage.exit.code", (Object[])new Object[]{output.getExitCode()}), (String)PythonProBundle.message((String)"python.coverage.error.generating.report")));
                    }
                }
                catch (Exception e) {
                    LOG.error("epic fail", (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/pro/coverage/PyCoverageUtil$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)generateReportTask);
    }

    @Nullable
    private static Module getModuleWithPySdk(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            PyCoverageUtil.$$$reportNull$$$0(1);
        }
        for (Module m : modules = ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkUtil.findPythonSdk((Module)m);
            if (sdk == null) continue;
            return m;
        }
        return null;
    }

    private static GeneralCommandLine createCommandLine(Module module, List<String> params) throws ExecutionException {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            throw new ExecutionException(DjangoBundle.message("manage.run.error.no-python", new Object[0]));
        }
        String homePath = sdk.getHomePath();
        if (homePath != null) {
            homePath = FileUtil.toSystemDependentName((String)homePath);
        }
        GeneralCommandLine cmd = PythonHelper.COVERAGE.newCommandLine(homePath, params);
        PythonEnvUtil.setPythonUnbuffered((Map)cmd.getEnvironment());
        return cmd;
    }

    static void addCoverageFileEnv(GeneralCommandLine cmdLine, String coverageFilePath) {
        cmdLine.getEnvironment().put("PYCHARM_COVERAGE_FILE", coverageFilePath);
    }

    static void addRunCoverageEnv(GeneralCommandLine cmdLine) {
        cmdLine.getEnvironment().put("PYCHARM_RUN_COVERAGE", "1");
    }

    static void addCoverageFileEnv(@NotNull PythonExecution coverageScript, @NotNull Function<TargetEnvironment, String> coverageFilePath) {
        if (coverageScript == null) {
            PyCoverageUtil.$$$reportNull$$$0(2);
        }
        if (coverageFilePath == null) {
            PyCoverageUtil.$$$reportNull$$$0(3);
        }
        coverageScript.addEnvironmentVariable("PYCHARM_COVERAGE_FILE", coverageFilePath);
    }

    static void addRunCoverageEnv(@NotNull PythonExecution coverageScript) {
        if (coverageScript == null) {
            PyCoverageUtil.$$$reportNull$$$0(4);
        }
        coverageScript.addEnvironmentVariable("PYCHARM_RUN_COVERAGE", "1");
    }

    static boolean isCoverageAvailable(@Nullable Module module, @Nullable String sdkHome) {
        Sdk pythonSdk = PythonSdkUtil.findSdkByPath((String)sdkHome);
        if (pythonSdk == null || module == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            PyQualifiedNameResolveContext context = PyResolveImportUtil.fromSdk((Project)module.getProject(), (Sdk)pythonSdk);
            List results = PyResolveImportUtil.resolveQualifiedName((QualifiedName)QualifiedName.fromDottedString((String)"coverage"), (PyQualifiedNameResolveContext)context);
            return !results.isEmpty();
        });
    }

    static void addBundledCoverageToPythonPath(Sdk sdk, Map<String, String> environment) {
        if (PySdkUtil.getLanguageLevelForSdk((Sdk)sdk).isAtLeast(LanguageLevel.PYTHON37)) {
            PythonHelper.COVERAGEPY_NEW.addToPythonPath(environment);
        } else {
            PythonHelper.COVERAGEPY_OLD.addToPythonPath(environment);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageScript";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageFilePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/coverage/PyCoverageUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateReport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleWithPySdk";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCoverageFileEnv";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addRunCoverageEnv";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

