/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 49724762904219L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1926466860 + (char)-18623, -1926466860 + -((char)-27261), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1926466860 + (char)-18624, -1926466860 + -((char)-12816), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 70610879865560L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.S();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (!bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1617534870 - 12138, 1617534870 - 16807, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1617534870 - 12137, 1617534870 - 22908, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1617534870 - 12140, 1617534870 - 19692, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 20052096570709L;
                            Object object = this.lock;
                            bl2 = SshAgentIpcService.v();
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1105706520 + -31298, -1105706520 + -21762, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1105706520 + -31299, 1105706520 + (char)-21405, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1105706520 + -31300, -1105706520 + -((char)-16973), (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1105706520 + -31293, 1105706520 + 25583, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1105706520 + -31294, -1105706520 + -((char)-18897), (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1105706520 + -31295, -1105706520 + -((char)-28274), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1105706520 + -31293, 1105706520 + 25583, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1105706520 + -31296, -1105706520 + -22231, (int)l2));
                            if (ActionTimestamp.v() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.v(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 67842522585352L;
                    bl = SshAgentIpcService.v();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 108558588145396L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                bl = SshAgentIpcService.S();
                synchronized (object3) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl3 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16420), 1005175830 + (char)-92, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16416), 1005175830 + (char)-10864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16421), 1005175830 + (char)-8900, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16416), 1005175830 + (char)-10864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16418), 1005175830 + (char)-12208, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16420), 1005175830 + (char)-92, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16416), 1005175830 + (char)-10864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16419), 1005175830 + (char)-8021, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n = Kernel32.INSTANCE.GetLastError();
                if (n == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl7 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16420), 1005175830 + (char)-92, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16416), 1005175830 + (char)-10864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16424), -1005175830 + -((char)-2576), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16416), 1005175830 + (char)-10864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16425), 1005306900 - (char)-10943, (int)l2) + ErrorToolsKt.prettyHRESULT(n)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl8;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl9 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl8 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl8) {
                boolean bl10 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16416), 1005175830 + (char)-10864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16418), 1005175830 + (char)-12208, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl11 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16420), 1005175830 + (char)-92, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16416), 1005175830 + (char)-10864, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1005175830 + -((char)-16422), 1005306900 - (char)-5150, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 6805465030142L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-2058192210 - -((char)-18045), 2058192210 - (char)-18613, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 80036066794006L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-648796500 - -((char)-13012), 648796500 - 25382, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u008f\u0093l\u0084a\u00ab>\u00f1\u00dd\u00f9\u0086\u00bb\u00a6\u0017?\u009e\u00ad`l\u00143\u001d\u00fbS\u0088\u0093~sW\u00af\u0012\u00a5\u00f6-\u00f4R9?\u00f9\u000e";
                        var4_3 = "\u008f\u0093l\u0084a\u00ab>\u00f1\u00dd\u00f9\u0086\u00bb\u00a6\u0017?\u009e\u00ad`l\u00143\u001d\u00fbS\u0088\u0093~sW\u00af\u0012\u00a5\u00f6-\u00f4R9?\u00f9\u000e".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 51;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 56;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 65;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 27;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 11;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 45;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 31;
                                        break;
                                    }
                                    default: {
                                        v11 = 52;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n, int n2, int n3) {
                    int n4 = (n ^ n3 ^ 0x69CF) & 0xFFFF;
                    if (b[n4] == null) {
                        int n5;
                        char[] cArray = a[n4].toCharArray();
                        int n6 = switch (cArray[0] & 0xFF) {
                            case 0 -> 153;
                            case 1 -> 156;
                            case 2 -> 107;
                            case 3 -> 41;
                            case 4 -> 3;
                            case 5 -> 66;
                            case 6 -> 93;
                            case 7 -> 181;
                            case 8 -> 251;
                            case 9 -> 28;
                            case 10 -> 39;
                            case 11 -> 64;
                            case 12 -> 178;
                            case 13 -> 84;
                            case 14 -> 92;
                            case 15 -> 32;
                            case 16 -> 220;
                            case 17 -> 140;
                            case 18 -> 151;
                            case 19 -> 148;
                            case 20 -> 243;
                            case 21 -> 203;
                            case 22 -> 124;
                            case 23 -> 224;
                            case 24 -> 42;
                            case 25 -> 250;
                            case 26 -> 136;
                            case 27 -> 100;
                            case 28 -> 115;
                            case 29 -> 172;
                            case 30 -> 30;
                            case 31 -> 14;
                            case 32 -> 202;
                            case 33 -> 215;
                            case 34 -> 131;
                            case 35 -> 130;
                            case 36 -> 80;
                            case 37 -> 143;
                            case 38 -> 49;
                            case 39 -> 108;
                            case 40 -> 188;
                            case 41 -> 179;
                            case 42 -> 50;
                            case 43 -> 227;
                            case 44 -> 126;
                            case 45 -> 127;
                            case 46 -> 158;
                            case 47 -> 98;
                            case 48 -> 233;
                            case 49 -> 106;
                            case 50 -> 157;
                            case 51 -> 163;
                            case 52 -> 109;
                            case 53 -> 72;
                            case 54 -> 34;
                            case 55 -> 63;
                            case 56 -> 226;
                            case 57 -> 137;
                            case 58 -> 180;
                            case 59 -> 44;
                            case 60 -> 90;
                            case 61 -> 99;
                            case 62 -> 214;
                            case 63 -> 169;
                            case 64 -> 0;
                            case 65 -> 33;
                            case 66 -> 102;
                            case 67 -> 122;
                            case 68 -> 11;
                            case 69 -> 13;
                            case 70 -> 31;
                            case 71 -> 246;
                            case 72 -> 45;
                            case 73 -> 65;
                            case 74 -> 68;
                            case 75 -> 150;
                            case 76 -> 12;
                            case 77 -> 183;
                            case 78 -> 121;
                            case 79 -> 191;
                            case 80 -> 187;
                            case 81 -> 174;
                            case 82 -> 253;
                            case 83 -> 228;
                            case 84 -> 141;
                            case 85 -> 94;
                            case 86 -> 110;
                            case 87 -> 229;
                            case 88 -> 184;
                            case 89 -> 176;
                            case 90 -> 87;
                            case 91 -> 192;
                            case 92 -> 74;
                            case 93 -> 213;
                            case 94 -> 208;
                            case 95 -> 242;
                            case 96 -> 200;
                            case 97 -> 5;
                            case 98 -> 247;
                            case 99 -> 58;
                            case 100 -> 248;
                            case 101 -> 160;
                            case 102 -> 236;
                            case 103 -> 193;
                            case 104 -> 138;
                            case 105 -> 231;
                            case 106 -> 218;
                            case 107 -> 132;
                            case 108 -> 46;
                            case 109 -> 19;
                            case 110 -> 117;
                            case 111 -> 43;
                            case 112 -> 255;
                            case 113 -> 9;
                            case 114 -> 81;
                            case 115 -> 60;
                            case 116 -> 10;
                            case 117 -> 29;
                            case 118 -> 154;
                            case 119 -> 116;
                            case 120 -> 237;
                            case 121 -> 17;
                            case 122 -> 119;
                            case 123 -> 83;
                            case 124 -> 240;
                            case 125 -> 4;
                            case 126 -> 177;
                            case 127 -> 85;
                            case 128 -> 40;
                            case 129 -> 112;
                            case 130 -> 47;
                            case 131 -> 146;
                            case 132 -> 15;
                            case 133 -> 6;
                            case 134 -> 168;
                            case 135 -> 101;
                            case 136 -> 48;
                            case 137 -> 54;
                            case 138 -> 198;
                            case 139 -> 16;
                            case 140 -> 56;
                            case 141 -> 104;
                            case 142 -> 249;
                            case 143 -> 201;
                            case 144 -> 25;
                            case 145 -> 197;
                            case 146 -> 166;
                            case 147 -> 195;
                            case 148 -> 145;
                            case 149 -> 171;
                            case 150 -> 155;
                            case 151 -> 175;
                            case 152 -> 173;
                            case 153 -> 73;
                            case 154 -> 71;
                            case 155 -> 133;
                            case 156 -> 61;
                            case 157 -> 7;
                            case 158 -> 252;
                            case 159 -> 152;
                            case 160 -> 38;
                            case 161 -> 123;
                            case 162 -> 225;
                            case 163 -> 20;
                            case 164 -> 125;
                            case 165 -> 212;
                            case 166 -> 205;
                            case 167 -> 35;
                            case 168 -> 241;
                            case 169 -> 167;
                            case 170 -> 230;
                            case 171 -> 164;
                            case 172 -> 36;
                            case 173 -> 149;
                            case 174 -> 77;
                            case 175 -> 52;
                            case 176 -> 51;
                            case 177 -> 70;
                            case 178 -> 88;
                            case 179 -> 89;
                            case 180 -> 190;
                            case 181 -> 26;
                            case 182 -> 162;
                            case 183 -> 76;
                            case 184 -> 105;
                            case 185 -> 222;
                            case 186 -> 135;
                            case 187 -> 165;
                            case 188 -> 82;
                            case 189 -> 144;
                            case 190 -> 185;
                            case 191 -> 22;
                            case 192 -> 114;
                            case 193 -> 96;
                            case 194 -> 24;
                            case 195 -> 69;
                            case 196 -> 206;
                            case 197 -> 182;
                            case 198 -> 216;
                            case 199 -> 95;
                            case 200 -> 134;
                            case 201 -> 1;
                            case 202 -> 59;
                            case 203 -> 221;
                            case 204 -> 238;
                            case 205 -> 142;
                            case 206 -> 120;
                            case 207 -> 239;
                            case 208 -> 235;
                            case 209 -> 196;
                            case 210 -> 67;
                            case 211 -> 75;
                            case 212 -> 8;
                            case 213 -> 210;
                            case 214 -> 209;
                            case 215 -> 103;
                            case 216 -> 204;
                            case 217 -> 79;
                            case 218 -> 161;
                            case 219 -> 78;
                            case 220 -> 159;
                            case 221 -> 199;
                            case 222 -> 2;
                            case 223 -> 244;
                            case 224 -> 223;
                            case 225 -> 186;
                            case 226 -> 189;
                            case 227 -> 207;
                            case 228 -> 57;
                            case 229 -> 194;
                            case 230 -> 217;
                            case 231 -> 254;
                            case 232 -> 118;
                            case 233 -> 245;
                            case 234 -> 37;
                            case 235 -> 21;
                            case 236 -> 23;
                            case 237 -> 91;
                            case 238 -> 139;
                            case 239 -> 111;
                            case 240 -> 86;
                            case 241 -> 97;
                            case 242 -> 113;
                            case 243 -> 27;
                            case 244 -> 18;
                            case 245 -> 211;
                            case 246 -> 219;
                            case 247 -> 234;
                            case 248 -> 232;
                            case 249 -> 55;
                            case 250 -> 128;
                            case 251 -> 129;
                            case 252 -> 62;
                            case 253 -> 170;
                            case 254 -> 53;
                            default -> 147;
                        };
                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                            n5 += 256;
                        }
                        int n8 = 0;
                        while (n8 < cArray.length) {
                            int n9 = n8 % 2;
                            int n10 = n8;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n10];
                            if (n9 == 0) {
                                cArray2[n10] = (char)(c2 ^ n7);
                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                            } else {
                                cArray2[n10] = (char)(c2 ^ n5);
                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                            }
                            ++n8;
                        }
                        accept.3.b[n4] = new String(cArray).intern();
                    }
                    return b[n4];
                }
            };
            if (!bl) {
                ActionTimestamp.v(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 96605421973601L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.v();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (bl2) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1277408220 + -10633, 1277408220 - 5805, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1277408220 + -10629, 1277408220 + 4951, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1277408220 + -10656, -1277408220 + -17694, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1277408220 + -10633, 1277408220 - 5805, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1277408220 + -10629, 1277408220 + 4951, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1277408220 + -10657, 1277408220 + 15747, (int)l3) + ErrorToolsKt.prettyHRESULT(n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 51612611741802L;
                        boolean bl3 = SshAgentIpcService.S();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-10223460 + -26131, 10223460 + 15614, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-10223460 + -26130, 10223460 + 5101, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 78262089595630L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    bl = SshAgentIpcService.S();
                                    boolean bl3 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-804507660 - -30752, 804507660 - (char)-18324, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-804507660 - -30748, 804507660 - (char)-32176, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-804507660 - -30747, -804507660 - -((char)-28847), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-804507660 - -30748, 804507660 - (char)-32176, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-804507660 - -30754, 804507660 - (char)-28784, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-804507660 - -30752, 804507660 - (char)-18324, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-804507660 - -30748, 804507660 - (char)-32176, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-804507660 - -30732, 804507660 - (char)-16461, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl6 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-804507660 - -30752, 804507660 - (char)-18324, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-804507660 - -30748, 804507660 - (char)-32176, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-804507660 - -30733, 804507660 - (char)-19166, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl7 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl8 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-804507660 - -30752, 804507660 - (char)-18324, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-804507660 - -30748, 804507660 - (char)-32176, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-804507660 - -30734, -804507660 - -((char)-16800), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 16225200935706L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.v();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1185528150 - -15158, 1185528150 - 31490, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1185528150 - -15162, 1185528150 - 21774, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1185528150 - -15181, 1185528150 - (char)-22627, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1185528150 - -15174, -1185528150 - -29491, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1185528150 - -15158, 1185528150 - 31490, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1185528150 - -15162, 1185528150 - 21774, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1185528150 - -15175, -1185528150 - -15603, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1185528150 - -15158, 1185528150 - 31490, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1185528150 - -15162, 1185528150 - 21774, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1185528150 - -15176, 1185528150 - 30667, (int)l2) + ErrorToolsKt.prettyHRESULT(n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1185528150 - -15158, 1185528150 - 31490, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1185528150 - -15162, 1185528150 - 21774, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1185528150 - -15177, 1185528150 - 15138, (int)l2));
                    if (bl2) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1185528150 - -15158, 1185528150 - 31490, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1185528150 - -15162, 1185528150 - 21774, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1185528150 - -15138, 1185528150 - 26411, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1185528150 - -15139, -1185528150 - -((char)-19833), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = ":3\u000bmNU \u0006\u0014\u0003\u00a2\u0014\u00b8Sg,Z\u00bc\u00fc\u00b2\u00b3\u00cd8\u00aa\u0001\u00e2\u00daa\u008b\u0006\u0088:]L\u00ee0\u0018<\u00a6\u0093\b!\u00b4`\u00e0\u00fd\u00d6\u0095\u0086Oa\u00a8\u00a8\u000b\u0086r\u009d4P\u00a5\u00bc\t\u00f2\u00eb\u00d4\u0010\u00a2(\b;\u00cc\u0005\u000b\u00c7-\u00f3\u00fa\bv\u0090\u0082h-\u00d3J4\u0014D\u00d7\u0084\u008d,\u00c9\u00f6\u0018\u0089i\u00bf\u00b5&[l\u0080(9\u00c1\u00b5\u0005)\u00c6i\u00d3r\u001e\u00d6\u0011\u0083M\u00b2\u00d8\u00b0\u0017B<)\\\u0094\u001aq\u00a3\u00d1v\u00fbw\u00a9\"\u001a?1n\u00e9Y\u00fa)\u0010\u00a6-i\u000f\u00b8\u00a2\u0007\u00a1\u00c9X\u00d5-\ra\u00edS\t\u009f\u00d0\u00aff\u009e\u00c1\u00a9\u0099\u0016\u0010O\u00bfT]\u001f\u00e8\u00f3\u00e8Wq\u0006\bw\u00c5\u00a2\u00c7?A\u00d1yU\u00e0\u00d2\u007f:\u00caH})\u00a1B\u00ea\u0091gUP\u00d6RD\u001e\u0095\u00a1\u00d3\u00f6Z.\u001f\u0000\u009f\u00a3\u00fc\u00fbvPgS\u00ce\u00b5\u00b5\u00f5N\u009d\u00c0~\u009f\u00aa\u00e1\u00afP\u00b5t[\u00198\u0006\u0015\u0096-\u00aa\u00a5\b\u0094e\u00de\u00d6\u00a6\u0004;\u00ce\f\u00f8&C\u00a5\b\b\u0000H\u0000-\u00be\u0087F\u0087\u00ab\u00ac\u0014\u00f5>\u00bf\u008e\u00f7\u00f9J\u00d9\u00d1T\u00fbu\u00b9\u00ae\u008b\u0006;\f0\u00aeR\u009f{\u00d8 f\u00fb\u008c\u00e0(Q\u00cd\u00df]\tMm\u00d0e\u0019Q\u00af\u00b3\u000f\u00f4\u000b\u0002\u00a7\u00ef\u001c\u0006\u000f\f\u00b0\u0005\u00fc\u001c\u008e\u00df\u00b2n\u00b0~\u0096\u00b54\u001fE\u00a5\u00f1\u00db\u00fc\nyM{w\u000e5p*\u00e6\u0014Xh\u00b7~\u00eb\u0083\u0085\u00a0\u00a3M\u00ac\u00f1O\u00cd\u0014\u000b\u001ff\u00bf\u00ad\u0097\t\u00f3h~%{\u0015'\u009e\u00b8\u00b1p\u00e2\u00e3hB\u00c54\u00a8\u00895\u00c4\u00a1\u00e7J\u009dC\u0098)\u0010\u00dc[\u00f4\u00a9\u00ef\u00d3\u00f1.\u00e0\u00a4\u00c7!~R\u009b\u0091\u0011U\u00f6G\u00ea\u00d6\u0095\u00a6\u00a2\u00dbt\u008e\u0089\u00aeO\u00b4\u00f5\u00bd\u00fb\\\u0086\u00f2\u009f\u00b1\u0007\u00e5`\u00efy\u001b\u0003\u001e\u0007\u00bc\u000f\u00a0\u00f8\u0015\u00dc\u00c9(\u00c2\u0002M\u000e\u00db\u00dakpI\u0007b\r\u00da\u00a6o\u00031\u00af\u00efbqF\u007f\u00cb\u0003\u00d5\u00d9\u00e1\u00f9[\u009b\f\u00e9\u00f6\u00886@B\u00e2\u00f4\u000f\u00c7\u0081\u00a3W\u00ee\u009dh[\\\u00efaA\u001a{\u00e9\"s\u00967\u00bd$\u00c6b\u00d4\u0018DbS\u00fa\u00e0M\u0086\u0099\u009b\u00de\u00e5\u00dc\u0088\u0005\u0089Ou+P\u00b4?K\u009e&<\u000e\u00f1\u0012e%6\u00d3s\u0092?\u00d6\rf\u009b\u0095\u001b\u0081\u00e7l\u009e\u00ec\u0011\u00bd\u0096\u00b1\u00d1Q\u0087@\u009f<\u007f\u001f\u000e\u00b3\u00cbJy\u00a4\u00110\u000b\u0091\nD\u00be\u0010\u00b2wp\u001d\u0090\u000es\u0018d\u0096\u00d0\u00bdz\u00c9N\u00d3\u00d1\u00b0\u009f4 \u00ba\u00cc\u00fav\u00bfI\u0084m\u00db\u001b\u0016)R\u00dc\u0013\u00f4\u00a0\u00ef\u00f2\u00f1\n\u00e0 \u00c7\u00b5w_\u00c1N/q\u00f4\u00f9\u00baH\u0093\u0000\u00f0\u0092\u00d2\u00f4\u0001Z\u00cf\u000f;\u001f\u00b6\u00d6\u000b\u00a3.\u009b\t\u001c\u0094\u00df\u00f0\u009a\u00dc\u007faq";
                var4_3 = ":3\u000bmNU \u0006\u0014\u0003\u00a2\u0014\u00b8Sg,Z\u00bc\u00fc\u00b2\u00b3\u00cd8\u00aa\u0001\u00e2\u00daa\u008b\u0006\u0088:]L\u00ee0\u0018<\u00a6\u0093\b!\u00b4`\u00e0\u00fd\u00d6\u0095\u0086Oa\u00a8\u00a8\u000b\u0086r\u009d4P\u00a5\u00bc\t\u00f2\u00eb\u00d4\u0010\u00a2(\b;\u00cc\u0005\u000b\u00c7-\u00f3\u00fa\bv\u0090\u0082h-\u00d3J4\u0014D\u00d7\u0084\u008d,\u00c9\u00f6\u0018\u0089i\u00bf\u00b5&[l\u0080(9\u00c1\u00b5\u0005)\u00c6i\u00d3r\u001e\u00d6\u0011\u0083M\u00b2\u00d8\u00b0\u0017B<)\\\u0094\u001aq\u00a3\u00d1v\u00fbw\u00a9\"\u001a?1n\u00e9Y\u00fa)\u0010\u00a6-i\u000f\u00b8\u00a2\u0007\u00a1\u00c9X\u00d5-\ra\u00edS\t\u009f\u00d0\u00aff\u009e\u00c1\u00a9\u0099\u0016\u0010O\u00bfT]\u001f\u00e8\u00f3\u00e8Wq\u0006\bw\u00c5\u00a2\u00c7?A\u00d1yU\u00e0\u00d2\u007f:\u00caH})\u00a1B\u00ea\u0091gUP\u00d6RD\u001e\u0095\u00a1\u00d3\u00f6Z.\u001f\u0000\u009f\u00a3\u00fc\u00fbvPgS\u00ce\u00b5\u00b5\u00f5N\u009d\u00c0~\u009f\u00aa\u00e1\u00afP\u00b5t[\u00198\u0006\u0015\u0096-\u00aa\u00a5\b\u0094e\u00de\u00d6\u00a6\u0004;\u00ce\f\u00f8&C\u00a5\b\b\u0000H\u0000-\u00be\u0087F\u0087\u00ab\u00ac\u0014\u00f5>\u00bf\u008e\u00f7\u00f9J\u00d9\u00d1T\u00fbu\u00b9\u00ae\u008b\u0006;\f0\u00aeR\u009f{\u00d8 f\u00fb\u008c\u00e0(Q\u00cd\u00df]\tMm\u00d0e\u0019Q\u00af\u00b3\u000f\u00f4\u000b\u0002\u00a7\u00ef\u001c\u0006\u000f\f\u00b0\u0005\u00fc\u001c\u008e\u00df\u00b2n\u00b0~\u0096\u00b54\u001fE\u00a5\u00f1\u00db\u00fc\nyM{w\u000e5p*\u00e6\u0014Xh\u00b7~\u00eb\u0083\u0085\u00a0\u00a3M\u00ac\u00f1O\u00cd\u0014\u000b\u001ff\u00bf\u00ad\u0097\t\u00f3h~%{\u0015'\u009e\u00b8\u00b1p\u00e2\u00e3hB\u00c54\u00a8\u00895\u00c4\u00a1\u00e7J\u009dC\u0098)\u0010\u00dc[\u00f4\u00a9\u00ef\u00d3\u00f1.\u00e0\u00a4\u00c7!~R\u009b\u0091\u0011U\u00f6G\u00ea\u00d6\u0095\u00a6\u00a2\u00dbt\u008e\u0089\u00aeO\u00b4\u00f5\u00bd\u00fb\\\u0086\u00f2\u009f\u00b1\u0007\u00e5`\u00efy\u001b\u0003\u001e\u0007\u00bc\u000f\u00a0\u00f8\u0015\u00dc\u00c9(\u00c2\u0002M\u000e\u00db\u00dakpI\u0007b\r\u00da\u00a6o\u00031\u00af\u00efbqF\u007f\u00cb\u0003\u00d5\u00d9\u00e1\u00f9[\u009b\f\u00e9\u00f6\u00886@B\u00e2\u00f4\u000f\u00c7\u0081\u00a3W\u00ee\u009dh[\\\u00efaA\u001a{\u00e9\"s\u00967\u00bd$\u00c6b\u00d4\u0018DbS\u00fa\u00e0M\u0086\u0099\u009b\u00de\u00e5\u00dc\u0088\u0005\u0089Ou+P\u00b4?K\u009e&<\u000e\u00f1\u0012e%6\u00d3s\u0092?\u00d6\rf\u009b\u0095\u001b\u0081\u00e7l\u009e\u00ec\u0011\u00bd\u0096\u00b1\u00d1Q\u0087@\u009f<\u007f\u001f\u000e\u00b3\u00cbJy\u00a4\u00110\u000b\u0091\nD\u00be\u0010\u00b2wp\u001d\u0090\u000es\u0018d\u0096\u00d0\u00bdz\u00c9N\u00d3\u00d1\u00b0\u009f4 \u00ba\u00cc\u00fav\u00bfI\u0084m\u00db\u001b\u0016)R\u00dc\u0013\u00f4\u00a0\u00ef\u00f2\u00f1\n\u00e0 \u00c7\u00b5w_\u00c1N/q\u00f4\u00f9\u00baH\u0093\u0000\u00f0\u0092\u00d2\u00f4\u0001Z\u00cf\u000f;\u001f\u00b6\u00d6\u000b\u00a3.\u009b\t\u001c\u0094\u00df\u00f0\u009a\u00dc\u007faq".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 65;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "m\u0094\u0094\u009d0\u00a2\u00808$\u00b9\u0085\u008ca~\u00a5\u0080qk\u00a6\u00986h\"w\u0086\u0010\u00b3\u00eb \u0014\t\u001e5O\u0017\u00f9\u00c4\u00e9\u00c1\u00ea}\u0011T\f\u00f9\u00e7\u00e8f@|";
                    var4_3 = "m\u0094\u0094\u009d0\u00a2\u00808$\u00b9\u0085\u008ca~\u00a5\u0080qk\u00a6\u00986h\"w\u0086\u0010\u00b3\u00eb \u0014\t\u001e5O\u0017\u00f9\u00c4\u00e9\u00c1\u00ea}\u0011T\f\u00f9\u00e7\u00e8f@|".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 8;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 66;
                            break;
                        }
                        case 1: {
                            v15 = 17;
                            break;
                        }
                        case 2: {
                            v15 = 99;
                            break;
                        }
                        case 3: {
                            v15 = 97;
                            break;
                        }
                        case 4: {
                            v15 = 4;
                            break;
                        }
                        case 5: {
                            v15 = 21;
                            break;
                        }
                        default: {
                            v15 = 46;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0x12F6) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 54;
                case 1 -> 141;
                case 2 -> 61;
                case 3 -> 18;
                case 4 -> 72;
                case 5 -> 236;
                case 6 -> 97;
                case 7 -> 245;
                case 8 -> 59;
                case 9 -> 159;
                case 10 -> 94;
                case 11 -> 130;
                case 12 -> 153;
                case 13 -> 239;
                case 14 -> 0;
                case 15 -> 67;
                case 16 -> 104;
                case 17 -> 74;
                case 18 -> 48;
                case 19 -> 21;
                case 20 -> 19;
                case 21 -> 140;
                case 22 -> 233;
                case 23 -> 50;
                case 24 -> 196;
                case 25 -> 199;
                case 26 -> 99;
                case 27 -> 78;
                case 28 -> 160;
                case 29 -> 230;
                case 30 -> 133;
                case 31 -> 9;
                case 32 -> 41;
                case 33 -> 8;
                case 34 -> 145;
                case 35 -> 190;
                case 36 -> 73;
                case 37 -> 117;
                case 38 -> 179;
                case 39 -> 20;
                case 40 -> 234;
                case 41 -> 15;
                case 42 -> 248;
                case 43 -> 191;
                case 44 -> 51;
                case 45 -> 164;
                case 46 -> 170;
                case 47 -> 93;
                case 48 -> 64;
                case 49 -> 204;
                case 50 -> 105;
                case 51 -> 187;
                case 52 -> 200;
                case 53 -> 144;
                case 54 -> 113;
                case 55 -> 124;
                case 56 -> 214;
                case 57 -> 129;
                case 58 -> 24;
                case 59 -> 198;
                case 60 -> 161;
                case 61 -> 207;
                case 62 -> 180;
                case 63 -> 163;
                case 64 -> 192;
                case 65 -> 194;
                case 66 -> 46;
                case 67 -> 33;
                case 68 -> 91;
                case 69 -> 125;
                case 70 -> 171;
                case 71 -> 92;
                case 72 -> 4;
                case 73 -> 243;
                case 74 -> 57;
                case 75 -> 162;
                case 76 -> 35;
                case 77 -> 6;
                case 78 -> 96;
                case 79 -> 151;
                case 80 -> 127;
                case 81 -> 38;
                case 82 -> 3;
                case 83 -> 76;
                case 84 -> 228;
                case 85 -> 98;
                case 86 -> 17;
                case 87 -> 58;
                case 88 -> 86;
                case 89 -> 36;
                case 90 -> 122;
                case 91 -> 219;
                case 92 -> 155;
                case 93 -> 138;
                case 94 -> 13;
                case 95 -> 226;
                case 96 -> 232;
                case 97 -> 221;
                case 98 -> 205;
                case 99 -> 79;
                case 100 -> 75;
                case 101 -> 238;
                case 102 -> 119;
                case 103 -> 42;
                case 104 -> 70;
                case 105 -> 252;
                case 106 -> 150;
                case 107 -> 201;
                case 108 -> 43;
                case 109 -> 240;
                case 110 -> 81;
                case 111 -> 148;
                case 112 -> 186;
                case 113 -> 251;
                case 114 -> 231;
                case 115 -> 87;
                case 116 -> 255;
                case 117 -> 223;
                case 118 -> 16;
                case 119 -> 197;
                case 120 -> 250;
                case 121 -> 156;
                case 122 -> 109;
                case 123 -> 5;
                case 124 -> 132;
                case 125 -> 62;
                case 126 -> 100;
                case 127 -> 147;
                case 128 -> 29;
                case 129 -> 101;
                case 130 -> 235;
                case 131 -> 212;
                case 132 -> 80;
                case 133 -> 52;
                case 134 -> 30;
                case 135 -> 107;
                case 136 -> 244;
                case 137 -> 167;
                case 138 -> 28;
                case 139 -> 60;
                case 140 -> 69;
                case 141 -> 12;
                case 142 -> 66;
                case 143 -> 135;
                case 144 -> 218;
                case 145 -> 136;
                case 146 -> 183;
                case 147 -> 246;
                case 148 -> 213;
                case 149 -> 154;
                case 150 -> 27;
                case 151 -> 229;
                case 152 -> 32;
                case 153 -> 157;
                case 154 -> 118;
                case 155 -> 110;
                case 156 -> 158;
                case 157 -> 131;
                case 158 -> 225;
                case 159 -> 63;
                case 160 -> 195;
                case 161 -> 208;
                case 162 -> 112;
                case 163 -> 120;
                case 164 -> 182;
                case 165 -> 77;
                case 166 -> 216;
                case 167 -> 188;
                case 168 -> 40;
                case 169 -> 174;
                case 170 -> 22;
                case 171 -> 10;
                case 172 -> 249;
                case 173 -> 65;
                case 174 -> 89;
                case 175 -> 173;
                case 176 -> 215;
                case 177 -> 47;
                case 178 -> 128;
                case 179 -> 82;
                case 180 -> 126;
                case 181 -> 95;
                case 182 -> 241;
                case 183 -> 139;
                case 184 -> 14;
                case 185 -> 55;
                case 186 -> 206;
                case 187 -> 210;
                case 188 -> 23;
                case 189 -> 71;
                case 190 -> 26;
                case 191 -> 111;
                case 192 -> 169;
                case 193 -> 202;
                case 194 -> 84;
                case 195 -> 37;
                case 196 -> 185;
                case 197 -> 222;
                case 198 -> 1;
                case 199 -> 152;
                case 200 -> 68;
                case 201 -> 247;
                case 202 -> 211;
                case 203 -> 115;
                case 204 -> 175;
                case 205 -> 165;
                case 206 -> 85;
                case 207 -> 103;
                case 208 -> 237;
                case 209 -> 168;
                case 210 -> 178;
                case 211 -> 189;
                case 212 -> 2;
                case 213 -> 253;
                case 214 -> 49;
                case 215 -> 134;
                case 216 -> 121;
                case 217 -> 34;
                case 218 -> 56;
                case 219 -> 137;
                case 220 -> 254;
                case 221 -> 181;
                case 222 -> 45;
                case 223 -> 146;
                case 224 -> 25;
                case 225 -> 39;
                case 226 -> 7;
                case 227 -> 83;
                case 228 -> 53;
                case 229 -> 108;
                case 230 -> 114;
                case 231 -> 123;
                case 232 -> 227;
                case 233 -> 44;
                case 234 -> 193;
                case 235 -> 172;
                case 236 -> 220;
                case 237 -> 217;
                case 238 -> 88;
                case 239 -> 209;
                case 240 -> 142;
                case 241 -> 149;
                case 242 -> 242;
                case 243 -> 166;
                case 244 -> 143;
                case 245 -> 31;
                case 246 -> 90;
                case 247 -> 184;
                case 248 -> 106;
                case 249 -> 203;
                case 250 -> 177;
                case 251 -> 116;
                case 252 -> 224;
                case 253 -> 11;
                case 254 -> 102;
                default -> 176;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 125206238601770L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-648010080 - -12339, 648010080 - 14230, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 118874018495806L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.S();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2086372260 - -((char)-12950), 2086372260 - (char)-20936, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2086372260 - -((char)-12951), 2086372260 - (char)-21043, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2086372260 - -((char)-12952), 2086372260 - (char)-15989, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = ";\u00ff+\u00b0\u008f\\\u00b8\u008b\u0010\n\u00ac\u00fc{\u00cf\u009eI\u008a\u00a6=|D\u008a\u00ec\u00b1D";
                    var4_3 = ";\u00ff+\u00b0\u008f\\\u00b8\u008b\u0010\n\u00ac\u00fc{\u00cf\u009eI\u008a\u00a6=|D\u008a\u00ec\u00b1D".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 31;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "Th0\u00b4j5x`\u00a2\u00d9\u00ea\u0005\u0003\u00a4n\u00b5\u0001c$\u0014\u0097' \u00f8\u001c\u00b6\u0091\u0097\u009aM\u00e2T\u00c5\u00d6\u0082\u00ee\u00b2T:}\u009a]\u00e9\u00de\u0092\u00a1y!\u00a1d\u00b4\u00dc\u009a\u00ca\u00d4\u00e7#C\u00d3";
                        var4_3 = "Th0\u00b4j5x`\u00a2\u00d9\u00ea\u0005\u0003\u00a4n\u00b5\u0001c$\u0014\u0097' \u00f8\u001c\u00b6\u0091\u0097\u009aM\u00e2T\u00c5\u00d6\u0082\u00ee\u00b2T:}\u009a]\u00e9\u00de\u0092\u00a1y!\u00a1d\u00b4\u00dc\u009a\u00ca\u00d4\u00e7#C\u00d3".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 66;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 118;
                                break;
                            }
                            case 1: {
                                v15 = 76;
                                break;
                            }
                            case 2: {
                                v15 = 112;
                                break;
                            }
                            case 3: {
                                v15 = 27;
                                break;
                            }
                            case 4: {
                                v15 = 54;
                                break;
                            }
                            case 5: {
                                v15 = 125;
                                break;
                            }
                            default: {
                                v15 = 93;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x74F9) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 205;
                    case 1 -> 219;
                    case 2 -> 239;
                    case 3 -> 122;
                    case 4 -> 225;
                    case 5 -> 165;
                    case 6 -> 206;
                    case 7 -> 178;
                    case 8 -> 168;
                    case 9 -> 59;
                    case 10 -> 246;
                    case 11 -> 141;
                    case 12 -> 179;
                    case 13 -> 210;
                    case 14 -> 151;
                    case 15 -> 160;
                    case 16 -> 186;
                    case 17 -> 79;
                    case 18 -> 194;
                    case 19 -> 136;
                    case 20 -> 62;
                    case 21 -> 113;
                    case 22 -> 220;
                    case 23 -> 97;
                    case 24 -> 49;
                    case 25 -> 230;
                    case 26 -> 145;
                    case 27 -> 207;
                    case 28 -> 58;
                    case 29 -> 173;
                    case 30 -> 149;
                    case 31 -> 162;
                    case 32 -> 16;
                    case 33 -> 105;
                    case 34 -> 23;
                    case 35 -> 96;
                    case 36 -> 93;
                    case 37 -> 187;
                    case 38 -> 72;
                    case 39 -> 11;
                    case 40 -> 224;
                    case 41 -> 172;
                    case 42 -> 44;
                    case 43 -> 156;
                    case 44 -> 218;
                    case 45 -> 17;
                    case 46 -> 143;
                    case 47 -> 167;
                    case 48 -> 67;
                    case 49 -> 195;
                    case 50 -> 2;
                    case 51 -> 10;
                    case 52 -> 227;
                    case 53 -> 50;
                    case 54 -> 184;
                    case 55 -> 45;
                    case 56 -> 5;
                    case 57 -> 175;
                    case 58 -> 53;
                    case 59 -> 100;
                    case 60 -> 32;
                    case 61 -> 198;
                    case 62 -> 33;
                    case 63 -> 110;
                    case 64 -> 54;
                    case 65 -> 251;
                    case 66 -> 73;
                    case 67 -> 27;
                    case 68 -> 64;
                    case 69 -> 83;
                    case 70 -> 213;
                    case 71 -> 181;
                    case 72 -> 81;
                    case 73 -> 200;
                    case 74 -> 118;
                    case 75 -> 126;
                    case 76 -> 177;
                    case 77 -> 208;
                    case 78 -> 56;
                    case 79 -> 193;
                    case 80 -> 241;
                    case 81 -> 116;
                    case 82 -> 190;
                    case 83 -> 176;
                    case 84 -> 130;
                    case 85 -> 85;
                    case 86 -> 89;
                    case 87 -> 109;
                    case 88 -> 63;
                    case 89 -> 77;
                    case 90 -> 229;
                    case 91 -> 249;
                    case 92 -> 236;
                    case 93 -> 117;
                    case 94 -> 43;
                    case 95 -> 6;
                    case 96 -> 217;
                    case 97 -> 125;
                    case 98 -> 66;
                    case 99 -> 78;
                    case 100 -> 242;
                    case 101 -> 47;
                    case 102 -> 25;
                    case 103 -> 237;
                    case 104 -> 108;
                    case 105 -> 15;
                    case 106 -> 102;
                    case 107 -> 65;
                    case 108 -> 129;
                    case 109 -> 86;
                    case 110 -> 30;
                    case 111 -> 34;
                    case 112 -> 159;
                    case 113 -> 134;
                    case 114 -> 150;
                    case 115 -> 4;
                    case 116 -> 161;
                    case 117 -> 1;
                    case 118 -> 163;
                    case 119 -> 42;
                    case 120 -> 137;
                    case 121 -> 29;
                    case 122 -> 169;
                    case 123 -> 238;
                    case 124 -> 144;
                    case 125 -> 74;
                    case 126 -> 104;
                    case 127 -> 38;
                    case 128 -> 199;
                    case 129 -> 133;
                    case 130 -> 215;
                    case 131 -> 138;
                    case 132 -> 31;
                    case 133 -> 209;
                    case 134 -> 232;
                    case 135 -> 226;
                    case 136 -> 135;
                    case 137 -> 88;
                    case 138 -> 35;
                    case 139 -> 166;
                    case 140 -> 28;
                    case 141 -> 19;
                    case 142 -> 21;
                    case 143 -> 115;
                    case 144 -> 196;
                    case 145 -> 91;
                    case 146 -> 90;
                    case 147 -> 87;
                    case 148 -> 223;
                    case 149 -> 12;
                    case 150 -> 52;
                    case 151 -> 131;
                    case 152 -> 70;
                    case 153 -> 153;
                    case 154 -> 191;
                    case 155 -> 7;
                    case 156 -> 128;
                    case 157 -> 8;
                    case 158 -> 154;
                    case 159 -> 253;
                    case 160 -> 57;
                    case 161 -> 185;
                    case 162 -> 212;
                    case 163 -> 51;
                    case 164 -> 146;
                    case 165 -> 101;
                    case 166 -> 147;
                    case 167 -> 61;
                    case 168 -> 0;
                    case 169 -> 3;
                    case 170 -> 24;
                    case 171 -> 94;
                    case 172 -> 69;
                    case 173 -> 192;
                    case 174 -> 22;
                    case 175 -> 71;
                    case 176 -> 55;
                    case 177 -> 214;
                    case 178 -> 222;
                    case 179 -> 216;
                    case 180 -> 188;
                    case 181 -> 201;
                    case 182 -> 39;
                    case 183 -> 46;
                    case 184 -> 76;
                    case 185 -> 36;
                    case 186 -> 18;
                    case 187 -> 98;
                    case 188 -> 80;
                    case 189 -> 221;
                    case 190 -> 40;
                    case 191 -> 231;
                    case 192 -> 99;
                    case 193 -> 247;
                    case 194 -> 48;
                    case 195 -> 248;
                    case 196 -> 152;
                    case 197 -> 155;
                    case 198 -> 9;
                    case 199 -> 243;
                    case 200 -> 68;
                    case 201 -> 37;
                    case 202 -> 250;
                    case 203 -> 171;
                    case 204 -> 157;
                    case 205 -> 75;
                    case 206 -> 26;
                    case 207 -> 106;
                    case 208 -> 84;
                    case 209 -> 111;
                    case 210 -> 252;
                    case 211 -> 204;
                    case 212 -> 189;
                    case 213 -> 13;
                    case 214 -> 174;
                    case 215 -> 119;
                    case 216 -> 20;
                    case 217 -> 180;
                    case 218 -> 203;
                    case 219 -> 233;
                    case 220 -> 41;
                    case 221 -> 123;
                    case 222 -> 228;
                    case 223 -> 60;
                    case 224 -> 182;
                    case 225 -> 127;
                    case 226 -> 107;
                    case 227 -> 245;
                    case 228 -> 183;
                    case 229 -> 235;
                    case 230 -> 234;
                    case 231 -> 240;
                    case 232 -> 132;
                    case 233 -> 158;
                    case 234 -> 211;
                    case 235 -> 92;
                    case 236 -> 124;
                    case 237 -> 148;
                    case 238 -> 244;
                    case 239 -> 120;
                    case 240 -> 103;
                    case 241 -> 114;
                    case 242 -> 164;
                    case 243 -> 202;
                    case 244 -> 14;
                    case 245 -> 170;
                    case 246 -> 142;
                    case 247 -> 82;
                    case 248 -> 140;
                    case 249 -> 197;
                    case 250 -> 112;
                    case 251 -> 139;
                    case 252 -> 121;
                    case 253 -> 255;
                    case 254 -> 254;
                    default -> 95;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 7382038155493L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "y\u0014\u007f:\u0017UF \t~\u001el0Z\u0017[<X";
                    var5_4 = "y\u0014\u007f:\u0017UF \t~\u001el0Z\u0017[<X".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 85;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 71;
                                    break;
                                }
                                case 1: {
                                    v11 = 36;
                                    break;
                                }
                                case 2: {
                                    v11 = 88;
                                    break;
                                }
                                case 3: {
                                    v11 = 1;
                                    break;
                                }
                                case 4: {
                                    v11 = 39;
                                    break;
                                }
                                case 5: {
                                    v11 = 108;
                                    break;
                                }
                                default: {
                                    v11 = 32;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 34106719934435L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "[.j\u0014\u001d]l\u0004]0f\u000e\nQ/m\u000e\u0011_t{.d\tQ/m\u000e\u0011_tw$\rV)p\u0003\u001bRnw#w\t\u001a[";
                    var5_4 = "[.j\u0014\u001d]l\u0004]0f\u000e\nQ/m\u000e\u0011_t{.d\tQ/m\u000e\u0011_tw$\rV)p\u0003\u001bRnw#w\t\u001a[".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 31;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u001ag'XV\u0019,\u0006\u001ag'XZ\u0013";
                        var5_4 = "\u001ag'XV\u0019,\u0006\u001ag'XZ\u0013".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 84;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 13;
                                break;
                            }
                            case 1: {
                                v15 = 95;
                                break;
                            }
                            case 2: {
                                v15 = 28;
                                break;
                            }
                            case 3: {
                                v15 = 127;
                                break;
                            }
                            case 4: {
                                v15 = 107;
                                break;
                            }
                            case 5: {
                                v15 = 35;
                                break;
                            }
                            default: {
                                v15 = 31;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 10319273041635L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1533387930 - 12049, 1533387930 - 9841, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 125279704406105L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u001a\u0091\u00d5\u0006\u008d\u0003!\"\u0006\u0005\u0000\u000b\u00b0\u0091\u00c2\r\u00c7\u001b~\u00d9\u00eeTA\u0080\u0080\u0004\u00e4`t\u0010S$+\u00d5{@\u00d8?zwXC\u0005\u000b.V\u0005eH\u001c\u00f9W3Q\u00ae\u008bR\u00ba\u00f4\u00d0\u00bd\u0006\u00da\\\u00dfC\u00c9\u00ca\u0011\u00b1l\u00e1\u00d9x\u00e4\u00d9\u00a1\b\u00ee\u008c&\u008d\\f\u0016\u00d9n\u00f7\u00cc\u00a6\u00a4\u0082\\\u001b5d\u00ccw\u00f24\u00d8y\r~";
                    var4_3 = "\u001a\u0091\u00d5\u0006\u008d\u0003!\"\u0006\u0005\u0000\u000b\u00b0\u0091\u00c2\r\u00c7\u001b~\u00d9\u00eeTA\u0080\u0080\u0004\u00e4`t\u0010S$+\u00d5{@\u00d8?zwXC\u0005\u000b.V\u0005eH\u001c\u00f9W3Q\u00ae\u008bR\u00ba\u00f4\u00d0\u00bd\u0006\u00da\\\u00dfC\u00c9\u00ca\u0011\u00b1l\u00e1\u00d9x\u00e4\u00d9\u00a1\b\u00ee\u008c&\u008d\\f\u0016\u00d9n\u00f7\u00cc\u00a6\u00a4\u0082\\\u001b5d\u00ccw\u00f24\u00d8y\r~".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 81;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "y\u001bO\u0013\u00d6\u00b9L!\u00c9\u0095\u000f>\u00ce\u0085v\u00a6L#\u0015\u00f3\u0018k\u0010\u0095z{m\u00f5\u0098\u009f\u00df\u00cf\u00945,\u00af\u0006\u00f8Z\u00c2\u00f5i\u00ae\u00a4\u00c9S\u00c9s\u00eaJ>\u00d5\u00fb\u00f1\u00bds82e\u00af\u009a:\u00c7wg\u00c2\u00ef\u00c0\u00fd\u00ad\u00b2?\u00b5S.jp\\\u0096\u00a5'=\u00df4\u00b0\u00cd!\u00d3\u009bY\u00f2/J";
                        var4_3 = "y\u001bO\u0013\u00d6\u00b9L!\u00c9\u0095\u000f>\u00ce\u0085v\u00a6L#\u0015\u00f3\u0018k\u0010\u0095z{m\u00f5\u0098\u009f\u00df\u00cf\u00945,\u00af\u0006\u00f8Z\u00c2\u00f5i\u00ae\u00a4\u00c9S\u00c9s\u00eaJ>\u00d5\u00fb\u00f1\u00bds82e\u00af\u009a:\u00c7wg\u00c2\u00ef\u00c0\u00fd\u00ad\u00b2?\u00b5S.jp\\\u0096\u00a5'=\u00df4\u00b0\u00cd!\u00d3\u009bY\u00f2/J".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 80;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 94;
                                break;
                            }
                            case 1: {
                                v15 = 45;
                                break;
                            }
                            case 2: {
                                v15 = 14;
                                break;
                            }
                            case 3: {
                                v15 = 15;
                                break;
                            }
                            case 4: {
                                v15 = 48;
                                break;
                            }
                            case 5: {
                                v15 = 115;
                                break;
                            }
                            default: {
                                v15 = 29;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFEB6A) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 192;
                    case 1 -> 111;
                    case 2 -> 231;
                    case 3 -> 156;
                    case 4 -> 25;
                    case 5 -> 203;
                    case 6 -> 79;
                    case 7 -> 243;
                    case 8 -> 109;
                    case 9 -> 50;
                    case 10 -> 215;
                    case 11 -> 142;
                    case 12 -> 89;
                    case 13 -> 240;
                    case 14 -> 75;
                    case 15 -> 187;
                    case 16 -> 196;
                    case 17 -> 44;
                    case 18 -> 188;
                    case 19 -> 36;
                    case 20 -> 219;
                    case 21 -> 86;
                    case 22 -> 154;
                    case 23 -> 59;
                    case 24 -> 12;
                    case 25 -> 110;
                    case 26 -> 55;
                    case 27 -> 51;
                    case 28 -> 206;
                    case 29 -> 255;
                    case 30 -> 185;
                    case 31 -> 220;
                    case 32 -> 239;
                    case 33 -> 104;
                    case 34 -> 54;
                    case 35 -> 233;
                    case 36 -> 113;
                    case 37 -> 247;
                    case 38 -> 246;
                    case 39 -> 207;
                    case 40 -> 238;
                    case 41 -> 146;
                    case 42 -> 29;
                    case 43 -> 4;
                    case 44 -> 83;
                    case 45 -> 226;
                    case 46 -> 186;
                    case 47 -> 101;
                    case 48 -> 5;
                    case 49 -> 106;
                    case 50 -> 77;
                    case 51 -> 252;
                    case 52 -> 155;
                    case 53 -> 108;
                    case 54 -> 58;
                    case 55 -> 93;
                    case 56 -> 138;
                    case 57 -> 251;
                    case 58 -> 126;
                    case 59 -> 167;
                    case 60 -> 189;
                    case 61 -> 19;
                    case 62 -> 72;
                    case 63 -> 99;
                    case 64 -> 191;
                    case 65 -> 49;
                    case 66 -> 41;
                    case 67 -> 210;
                    case 68 -> 88;
                    case 69 -> 176;
                    case 70 -> 23;
                    case 71 -> 208;
                    case 72 -> 168;
                    case 73 -> 87;
                    case 74 -> 232;
                    case 75 -> 42;
                    case 76 -> 73;
                    case 77 -> 81;
                    case 78 -> 120;
                    case 79 -> 56;
                    case 80 -> 150;
                    case 81 -> 133;
                    case 82 -> 200;
                    case 83 -> 94;
                    case 84 -> 11;
                    case 85 -> 180;
                    case 86 -> 149;
                    case 87 -> 2;
                    case 88 -> 1;
                    case 89 -> 74;
                    case 90 -> 34;
                    case 91 -> 39;
                    case 92 -> 6;
                    case 93 -> 118;
                    case 94 -> 123;
                    case 95 -> 112;
                    case 96 -> 46;
                    case 97 -> 212;
                    case 98 -> 53;
                    case 99 -> 24;
                    case 100 -> 107;
                    case 101 -> 82;
                    case 102 -> 202;
                    case 103 -> 30;
                    case 104 -> 48;
                    case 105 -> 135;
                    case 106 -> 222;
                    case 107 -> 70;
                    case 108 -> 124;
                    case 109 -> 241;
                    case 110 -> 230;
                    case 111 -> 182;
                    case 112 -> 45;
                    case 113 -> 197;
                    case 114 -> 172;
                    case 115 -> 195;
                    case 116 -> 98;
                    case 117 -> 128;
                    case 118 -> 225;
                    case 119 -> 8;
                    case 120 -> 224;
                    case 121 -> 91;
                    case 122 -> 244;
                    case 123 -> 80;
                    case 124 -> 97;
                    case 125 -> 21;
                    case 126 -> 130;
                    case 127 -> 250;
                    case 128 -> 90;
                    case 129 -> 114;
                    case 130 -> 141;
                    case 131 -> 163;
                    case 132 -> 9;
                    case 133 -> 143;
                    case 134 -> 236;
                    case 135 -> 47;
                    case 136 -> 161;
                    case 137 -> 194;
                    case 138 -> 78;
                    case 139 -> 127;
                    case 140 -> 160;
                    case 141 -> 162;
                    case 142 -> 234;
                    case 143 -> 139;
                    case 144 -> 0;
                    case 145 -> 32;
                    case 146 -> 181;
                    case 147 -> 62;
                    case 148 -> 131;
                    case 149 -> 145;
                    case 150 -> 242;
                    case 151 -> 43;
                    case 152 -> 199;
                    case 153 -> 129;
                    case 154 -> 102;
                    case 155 -> 105;
                    case 156 -> 209;
                    case 157 -> 35;
                    case 158 -> 33;
                    case 159 -> 205;
                    case 160 -> 69;
                    case 161 -> 166;
                    case 162 -> 10;
                    case 163 -> 171;
                    case 164 -> 183;
                    case 165 -> 122;
                    case 166 -> 169;
                    case 167 -> 147;
                    case 168 -> 153;
                    case 169 -> 28;
                    case 170 -> 65;
                    case 171 -> 26;
                    case 172 -> 76;
                    case 173 -> 237;
                    case 174 -> 100;
                    case 175 -> 136;
                    case 176 -> 140;
                    case 177 -> 132;
                    case 178 -> 193;
                    case 179 -> 221;
                    case 180 -> 223;
                    case 181 -> 204;
                    case 182 -> 31;
                    case 183 -> 14;
                    case 184 -> 165;
                    case 185 -> 248;
                    case 186 -> 67;
                    case 187 -> 174;
                    case 188 -> 37;
                    case 189 -> 213;
                    case 190 -> 60;
                    case 191 -> 16;
                    case 192 -> 214;
                    case 193 -> 115;
                    case 194 -> 173;
                    case 195 -> 217;
                    case 196 -> 249;
                    case 197 -> 177;
                    case 198 -> 116;
                    case 199 -> 148;
                    case 200 -> 159;
                    case 201 -> 125;
                    case 202 -> 38;
                    case 203 -> 253;
                    case 204 -> 17;
                    case 205 -> 84;
                    case 206 -> 134;
                    case 207 -> 228;
                    case 208 -> 20;
                    case 209 -> 27;
                    case 210 -> 57;
                    case 211 -> 179;
                    case 212 -> 144;
                    case 213 -> 157;
                    case 214 -> 184;
                    case 215 -> 117;
                    case 216 -> 158;
                    case 217 -> 85;
                    case 218 -> 40;
                    case 219 -> 178;
                    case 220 -> 95;
                    case 221 -> 92;
                    case 222 -> 66;
                    case 223 -> 152;
                    case 224 -> 64;
                    case 225 -> 175;
                    case 226 -> 229;
                    case 227 -> 119;
                    case 228 -> 3;
                    case 229 -> 137;
                    case 230 -> 235;
                    case 231 -> 96;
                    case 232 -> 151;
                    case 233 -> 216;
                    case 234 -> 201;
                    case 235 -> 18;
                    case 236 -> 218;
                    case 237 -> 15;
                    case 238 -> 52;
                    case 239 -> 198;
                    case 240 -> 68;
                    case 241 -> 164;
                    case 242 -> 254;
                    case 243 -> 227;
                    case 244 -> 22;
                    case 245 -> 71;
                    case 246 -> 190;
                    case 247 -> 61;
                    case 248 -> 13;
                    case 249 -> 170;
                    case 250 -> 211;
                    case 251 -> 103;
                    case 252 -> 245;
                    case 253 -> 7;
                    case 254 -> 63;
                    default -> 121;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 826423282868L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1789629780 - -((char)-25000), 1789629780 - (char)-20447, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 2339739785182L;
                    boolean bl = SshAgentIpcService.v();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1017365340 + (char)-28909, -1017365340 + -23546, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (bl2) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 80112712136165L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u001cw\u00e1\u008ec\u0003\u00a6\u00eb\u00e0";
                var4_3 = "\u001cw\u00e1\u008ec\u0003\u00a6\u00eb\u00e0".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 76;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 117;
                                break;
                            }
                            case 1: {
                                v11 = 122;
                                break;
                            }
                            case 2: {
                                v11 = 33;
                                break;
                            }
                            case 3: {
                                v11 = 15;
                                break;
                            }
                            case 4: {
                                v11 = 3;
                                break;
                            }
                            case 5: {
                                v11 = 41;
                                break;
                            }
                            default: {
                                v11 = 38;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFF85B0) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 95;
                    case 1 -> 26;
                    case 2 -> 207;
                    case 3 -> 96;
                    case 4 -> 103;
                    case 5 -> 194;
                    case 6 -> 165;
                    case 7 -> 151;
                    case 8 -> 58;
                    case 9 -> 141;
                    case 10 -> 171;
                    case 11 -> 100;
                    case 12 -> 242;
                    case 13 -> 87;
                    case 14 -> 237;
                    case 15 -> 147;
                    case 16 -> 46;
                    case 17 -> 69;
                    case 18 -> 133;
                    case 19 -> 35;
                    case 20 -> 132;
                    case 21 -> 102;
                    case 22 -> 159;
                    case 23 -> 108;
                    case 24 -> 212;
                    case 25 -> 2;
                    case 26 -> 214;
                    case 27 -> 184;
                    case 28 -> 198;
                    case 29 -> 31;
                    case 30 -> 98;
                    case 31 -> 153;
                    case 32 -> 77;
                    case 33 -> 25;
                    case 34 -> 19;
                    case 35 -> 73;
                    case 36 -> 23;
                    case 37 -> 67;
                    case 38 -> 20;
                    case 39 -> 41;
                    case 40 -> 126;
                    case 41 -> 127;
                    case 42 -> 0;
                    case 43 -> 249;
                    case 44 -> 246;
                    case 45 -> 118;
                    case 46 -> 8;
                    case 47 -> 177;
                    case 48 -> 110;
                    case 49 -> 240;
                    case 50 -> 22;
                    case 51 -> 124;
                    case 52 -> 51;
                    case 53 -> 170;
                    case 54 -> 122;
                    case 55 -> 233;
                    case 56 -> 115;
                    case 57 -> 71;
                    case 58 -> 135;
                    case 59 -> 27;
                    case 60 -> 189;
                    case 61 -> 32;
                    case 62 -> 144;
                    case 63 -> 168;
                    case 64 -> 222;
                    case 65 -> 61;
                    case 66 -> 220;
                    case 67 -> 208;
                    case 68 -> 196;
                    case 69 -> 106;
                    case 70 -> 50;
                    case 71 -> 228;
                    case 72 -> 28;
                    case 73 -> 89;
                    case 74 -> 66;
                    case 75 -> 234;
                    case 76 -> 247;
                    case 77 -> 140;
                    case 78 -> 94;
                    case 79 -> 97;
                    case 80 -> 232;
                    case 81 -> 138;
                    case 82 -> 75;
                    case 83 -> 29;
                    case 84 -> 11;
                    case 85 -> 101;
                    case 86 -> 231;
                    case 87 -> 114;
                    case 88 -> 190;
                    case 89 -> 70;
                    case 90 -> 213;
                    case 91 -> 137;
                    case 92 -> 197;
                    case 93 -> 215;
                    case 94 -> 38;
                    case 95 -> 109;
                    case 96 -> 251;
                    case 97 -> 30;
                    case 98 -> 244;
                    case 99 -> 40;
                    case 100 -> 199;
                    case 101 -> 178;
                    case 102 -> 176;
                    case 103 -> 192;
                    case 104 -> 113;
                    case 105 -> 210;
                    case 106 -> 59;
                    case 107 -> 243;
                    case 108 -> 65;
                    case 109 -> 131;
                    case 110 -> 42;
                    case 111 -> 148;
                    case 112 -> 91;
                    case 113 -> 230;
                    case 114 -> 181;
                    case 115 -> 93;
                    case 116 -> 80;
                    case 117 -> 6;
                    case 118 -> 173;
                    case 119 -> 90;
                    case 120 -> 225;
                    case 121 -> 120;
                    case 122 -> 24;
                    case 123 -> 193;
                    case 124 -> 92;
                    case 125 -> 62;
                    case 126 -> 57;
                    case 127 -> 129;
                    case 128 -> 149;
                    case 129 -> 217;
                    case 130 -> 238;
                    case 131 -> 169;
                    case 132 -> 209;
                    case 133 -> 227;
                    case 134 -> 81;
                    case 135 -> 49;
                    case 136 -> 166;
                    case 137 -> 250;
                    case 138 -> 188;
                    case 139 -> 1;
                    case 140 -> 145;
                    case 141 -> 253;
                    case 142 -> 152;
                    case 143 -> 134;
                    case 144 -> 36;
                    case 145 -> 78;
                    case 146 -> 76;
                    case 147 -> 218;
                    case 148 -> 104;
                    case 149 -> 12;
                    case 150 -> 33;
                    case 151 -> 167;
                    case 152 -> 174;
                    case 153 -> 180;
                    case 154 -> 15;
                    case 155 -> 162;
                    case 156 -> 252;
                    case 157 -> 255;
                    case 158 -> 116;
                    case 159 -> 136;
                    case 160 -> 7;
                    case 161 -> 200;
                    case 162 -> 68;
                    case 163 -> 236;
                    case 164 -> 55;
                    case 165 -> 16;
                    case 166 -> 204;
                    case 167 -> 17;
                    case 168 -> 211;
                    case 169 -> 146;
                    case 170 -> 155;
                    case 171 -> 163;
                    case 172 -> 139;
                    case 173 -> 172;
                    case 174 -> 245;
                    case 175 -> 117;
                    case 176 -> 10;
                    case 177 -> 254;
                    case 178 -> 74;
                    case 179 -> 82;
                    case 180 -> 224;
                    case 181 -> 160;
                    case 182 -> 83;
                    case 183 -> 219;
                    case 184 -> 21;
                    case 185 -> 241;
                    case 186 -> 221;
                    case 187 -> 63;
                    case 188 -> 121;
                    case 189 -> 164;
                    case 190 -> 18;
                    case 191 -> 142;
                    case 192 -> 44;
                    case 193 -> 235;
                    case 194 -> 157;
                    case 195 -> 72;
                    case 196 -> 14;
                    case 197 -> 202;
                    case 198 -> 143;
                    case 199 -> 86;
                    case 200 -> 183;
                    case 201 -> 3;
                    case 202 -> 88;
                    case 203 -> 34;
                    case 204 -> 99;
                    case 205 -> 48;
                    case 206 -> 52;
                    case 207 -> 161;
                    case 208 -> 119;
                    case 209 -> 9;
                    case 210 -> 248;
                    case 211 -> 206;
                    case 212 -> 185;
                    case 213 -> 54;
                    case 214 -> 39;
                    case 215 -> 186;
                    case 216 -> 223;
                    case 217 -> 123;
                    case 218 -> 105;
                    case 219 -> 205;
                    case 220 -> 47;
                    case 221 -> 203;
                    case 222 -> 84;
                    case 223 -> 158;
                    case 224 -> 37;
                    case 225 -> 187;
                    case 226 -> 125;
                    case 227 -> 175;
                    case 228 -> 195;
                    case 229 -> 64;
                    case 230 -> 85;
                    case 231 -> 13;
                    case 232 -> 179;
                    case 233 -> 226;
                    case 234 -> 156;
                    case 235 -> 130;
                    case 236 -> 111;
                    case 237 -> 5;
                    case 238 -> 216;
                    case 239 -> 150;
                    case 240 -> 107;
                    case 241 -> 201;
                    case 242 -> 191;
                    case 243 -> 239;
                    case 244 -> 128;
                    case 245 -> 154;
                    case 246 -> 56;
                    case 247 -> 60;
                    case 248 -> 43;
                    case 249 -> 112;
                    case 250 -> 4;
                    case 251 -> 182;
                    case 252 -> 79;
                    case 253 -> 53;
                    case 254 -> 45;
                    default -> 229;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

