/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.export;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveGraphToImageDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private TextFieldWithBrowseButton myDirectory;
    private JTextField myFileName;
    private JComboBox myExtension;

    protected SaveGraphToImageDialog(Project project, @Nullable VirtualFile directory, @Nullable String defaultFileName, @NotNull Collection<@NlsSafe String> extensions) {
        if (extensions == null) {
            SaveGraphToImageDialog.v(0);
        }
        super(project, false);
        Object[] objectArray = new Object[]{};
        this.S();
        this.setTitle(GraphBundle.message((String)"dialog.title.export.to.file", (Object[])objectArray));
        this.myDirectory.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(GraphBundle.message((String)"dialog.title.choose.directory", (Object[])new Object[0])).withDescription(GraphBundle.message((String)"dialog.title.choose.directory", (Object[])new Object[0])));
        if (directory != null) {
            this.myDirectory.setText(directory.getPath());
        }
        this.myDirectory.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e2) {
                if (e2 == null) {
                    1.v(0);
                }
                SaveGraphToImageDialog.this.myDirectory.getTextField().setForeground(SaveGraphToImageDialog.this.getDirectory() != null ? SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor() : SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
                SaveGraphToImageDialog.this.v();
            }

            private static /* synthetic */ void v(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/graph/builder/actions/export/SaveGraphToImageDialog$1", "textChanged"));
            }
        });
        if (extensions.isEmpty()) {
            this.myExtension.setEnabled(false);
        } else {
            for (String string : extensions) {
                this.myExtension.addItem(string);
            }
        }
        if (defaultFileName != null) {
            this.myFileName.setText(defaultFileName);
        }
        this.myFileName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e2) {
                if (e2 == null) {
                    2.v(0);
                }
                SaveGraphToImageDialog.this.myFileName.setForeground(SaveGraphToImageDialog.v(SaveGraphToImageDialog.this.myFileName.getText()) ? SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor() : SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
                SaveGraphToImageDialog.this.v();
            }

            private static /* synthetic */ void v(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/graph/builder/actions/export/SaveGraphToImageDialog$2", "textChanged"));
            }
        });
        this.v();
        this.init();
    }

    private void v() {
        this.getOKAction().setEnabled(!this.myFileName.getText().trim().isEmpty() && this.getDirectory() != null && SaveGraphToImageDialog.v(this.myFileName.getText().trim()));
    }

    @Nullable
    public VirtualFile getDirectory() {
        String string = this.myDirectory.getText();
        return LocalFileSystem.getInstance().findFileByPath(string);
    }

    @Nullable
    public String getPath() {
        VirtualFile virtualFile = this.getDirectory();
        if (virtualFile == null || this.myFileName.getText().trim().isEmpty()) {
            return null;
        }
        return virtualFile.getPath() + File.separator + this.myFileName.getText() + "." + String.valueOf(this.myExtension.getSelectedItem());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private static boolean v(String string) {
        return !string.contains(".") && !string.contains("\\") && !string.contains("/");
    }

    private /* synthetic */ void S() {
        JComboBox jComboBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(300, -1), null));
        JLabel jLabel = new JLabel();
        this.v(jLabel, DynamicBundle.getBundle((String)"messages/GraphBundle", SaveGraphToImageDialog.class).getString("save.graph.dialog.directory"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.v(jLabel2, DynamicBundle.getBundle((String)"messages/GraphBundle", SaveGraphToImageDialog.class).getString("save.graph.dialog.file.name"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileName = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.v(jLabel3, DynamicBundle.getBundle((String)"messages/GraphBundle", SaveGraphToImageDialog.class).getString("save.graph.dialog.save.as"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExtension = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void v(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl && string.charAt(i10) != '&') {
                    bl = true;
                    c2 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static /* synthetic */ void v(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/openapi/graph/builder/actions/export/SaveGraphToImageDialog", "<init>"));
    }
}

