/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.google.common.collect.BiMap;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphImplUtil {
    @NotNull
    public static final Key<?> NODE_DRAGGED_INFO = Key.create((String)"NODE_DRAGGED_INFO");

    private GraphImplUtil() {
    }

    @Nullable
    public static <N, E> Node getExistedNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (dataMaps == null) {
            GraphImplUtil.v(0);
        }
        if (name == null) {
            GraphImplUtil.v(1);
        }
        if (equalityObjects == null) {
            GraphImplUtil.v(2);
        }
        dataMaps.assertReadAccess();
        ComparableNode comparableNode = GraphImplUtil.v(name, equalityObjects);
        BiMap<Node, ComparableNode> biMap = dataMaps.getNodeEqualityDataMap();
        return (Node)biMap.inverse().get((Object)comparableNode);
    }

    @Nullable
    public static <N, E> Edge getExistedEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object ... equalityObjects) {
        if (dataMaps == null) {
            GraphImplUtil.v(3);
        }
        if (node1 == null) {
            GraphImplUtil.v(4);
        }
        if (node2 == null) {
            GraphImplUtil.v(5);
        }
        if (name == null) {
            GraphImplUtil.v(6);
        }
        if (equalityObjects == null) {
            GraphImplUtil.v(7);
        }
        dataMaps.assertReadAccess();
        ComparableEdge comparableEdge = GraphImplUtil.v(dataMaps, name, node1, node2, equalityObjects);
        BiMap<Edge, ComparableEdge> biMap = dataMaps.getEdgeEqualityDataMap();
        return (Edge)biMap.inverse().get((Object)comparableEdge);
    }

    @NotNull
    public static List<Node> getNodes(@NotNull Graph graph) {
        if (graph == null) {
            GraphImplUtil.v(8);
        }
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(graph.getNodeArray()));
        Arrays.stream(graph.getNodeArray()).filter(node -> hierarchyManager.isFolderNode(node)).flatMap(node -> GraphImplUtil.getNodes(hierarchyManager.getInnerGraph(node)).stream()).forEach(arrayList::add);
        ArrayList<Node> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.v(9);
        }
        return arrayList2;
    }

    @NotNull
    public static List<Edge> getEdges(@NotNull Graph graph) {
        if (graph == null) {
            GraphImplUtil.v(10);
        }
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Edge> arrayList = new ArrayList<Edge>(Arrays.asList(graph.getEdgeArray()));
        Arrays.stream(graph.getNodeArray()).filter(node -> hierarchyManager.isFolderNode(node)).flatMap(node -> GraphImplUtil.getEdges(hierarchyManager.getInnerGraph(node)).stream()).forEach(arrayList::add);
        ArrayList<Edge> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.v(11);
        }
        return arrayList2;
    }

    @NotNull
    public static <N, E> Node createNode(@NotNull Graph graph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (graph == null) {
            GraphImplUtil.v(12);
        }
        if (dataMaps == null) {
            GraphImplUtil.v(13);
        }
        if (name == null) {
            GraphImplUtil.v(14);
        }
        if (equalityObjects == null) {
            GraphImplUtil.v(15);
        }
        dataMaps.assertWriteAccess();
        return GraphImplUtil.createNode(graph, null, dataMaps, name, equalityObjects);
    }

    @NotNull
    public static <N, E> Node createNode(@NotNull Graph rootGraph, @Nullable Graph innerGraph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (rootGraph == null) {
            GraphImplUtil.v(16);
        }
        if (dataMaps == null) {
            GraphImplUtil.v(17);
        }
        if (name == null) {
            GraphImplUtil.v(18);
        }
        if (equalityObjects == null) {
            GraphImplUtil.v(19);
        }
        dataMaps.assertWriteAccess();
        Node node = innerGraph == null ? rootGraph.createNode() : innerGraph.createNode();
        GraphImplUtil.setNodeName(dataMaps, node, name);
        dataMaps.getNodeEqualityDataMap().put((Object)node, (Object)GraphImplUtil.v(name, equalityObjects));
        Node node2 = node;
        if (node2 == null) {
            GraphImplUtil.v(20);
        }
        return node2;
    }

    @NotNull
    private static ComparableNode v(@NotNull String string, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.v(21);
        }
        if (objectArray == null) {
            GraphImplUtil.v(22);
        }
        return new ComparableNode("", objectArray);
    }

    @NotNull
    private static <N, E> ComparableEdge v(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull String string, @NotNull Node node, @NotNull Node node2, Object ... objectArray) {
        if (graphDataMaps == null) {
            GraphImplUtil.v(23);
        }
        if (string == null) {
            GraphImplUtil.v(24);
        }
        if (node == null) {
            GraphImplUtil.v(25);
        }
        if (node2 == null) {
            GraphImplUtil.v(26);
        }
        if (objectArray == null) {
            GraphImplUtil.v(27);
        }
        return new ComparableEdge(string, GraphImplUtil.v(graphDataMaps, node), GraphImplUtil.v(graphDataMaps, node2), objectArray);
    }

    @NotNull
    private static <N, E> ComparableNode v(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node) {
        if (graphDataMaps == null) {
            GraphImplUtil.v(28);
        }
        if (node == null) {
            GraphImplUtil.v(29);
        }
        return GraphImplUtil.v(GraphImplUtil.getNodeName(graphDataMaps, node), GraphImplUtil.S(graphDataMaps, node));
    }

    @NotNull
    public static <N, E> String getNodeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.v(30);
        }
        if (node == null) {
            GraphImplUtil.v(31);
        }
        dataMaps.assertReadAccess();
        String string = dataMaps.getNodeNameDataMap().get(node);
        String string2 = string == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.v(32);
        }
        return string2;
    }

    public static <N, E> void setNodeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node, @NotNull String name) {
        if (dataMaps == null) {
            GraphImplUtil.v(33);
        }
        if (node == null) {
            GraphImplUtil.v(34);
        }
        if (name == null) {
            GraphImplUtil.v(35);
        }
        dataMaps.getNodeNameDataMap().put(node, name);
    }

    public static <N, E> void setNodeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node, @NotNull N nodeObject) {
        if (dataMaps == null) {
            GraphImplUtil.v(36);
        }
        if (node == null) {
            GraphImplUtil.v(37);
        }
        if (nodeObject == null) {
            GraphImplUtil.v(38);
        }
        dataMaps.assertWriteAccess();
        dataMaps.getNodeObjectDataBiMap().forcePut((Object)node, nodeObject);
    }

    public static void expandAllParentNodes(@NotNull Node node, @NotNull HierarchyManager hierarchyManager) {
        Node node2;
        if (node == null) {
            GraphImplUtil.v(39);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.v(40);
        }
        if (hierarchyManager.isFolderNode(node)) {
            hierarchyManager.openFolder(node);
        }
        if ((node2 = hierarchyManager.getParentNode(node)) != null) {
            GraphImplUtil.expandAllParentNodes(node2, hierarchyManager);
        }
    }

    @NotNull
    public static <N, E> Node getOrCreateGroupNode(@NotNull Graph2D graph, @NotNull HierarchyManager hierarchyManager, @NotNull NodeGroupDescriptor groupDescriptor, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull GraphDataModel<N, E> dataModel) {
        if (graph == null) {
            GraphImplUtil.v(41);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.v(42);
        }
        if (groupDescriptor == null) {
            GraphImplUtil.v(43);
        }
        if (dataMaps == null) {
            GraphImplUtil.v(44);
        }
        if (dataModel == null) {
            GraphImplUtil.v(45);
        }
        dataMaps.assertWriteAccess();
        Node node = GraphImplUtil.v(graph, groupDescriptor, hierarchyManager, dataMaps);
        if (node != null) {
            Node node2 = node;
            if (node2 == null) {
                GraphImplUtil.v(46);
            }
            return node2;
        }
        NodeGroupDescriptor nodeGroupDescriptor = dataModel.getGroup(groupDescriptor);
        if (nodeGroupDescriptor != null) {
            Node node3 = GraphImplUtil.v(graph, nodeGroupDescriptor, hierarchyManager, dataMaps);
            if (node3 == null) {
                node3 = GraphImplUtil.getOrCreateGroupNode(graph, hierarchyManager, nodeGroupDescriptor, dataMaps, dataModel);
            } else {
                GraphImplUtil.expandAllParentNodes(node3, hierarchyManager);
            }
            Node node4 = node3;
            Node node5 = (Node)dataMaps.getActionExecutor().computeWriteAction(() -> GraphImplUtil.v(hierarchyManager, graph, groupDescriptor, node4, dataMaps));
            if (node5 == null) {
                GraphImplUtil.v(47);
            }
            return node5;
        }
        Node node6 = (Node)dataMaps.getActionExecutor().computeWriteAction(() -> GraphImplUtil.v(hierarchyManager, graph, groupDescriptor, dataMaps));
        if (node6 == null) {
            GraphImplUtil.v(48);
        }
        return node6;
    }

    @Nullable
    public static <N, E> NodeGroupDescriptor getGroup(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node groupNode) {
        if (dataMaps == null) {
            GraphImplUtil.v(49);
        }
        if (groupNode == null) {
            GraphImplUtil.v(50);
        }
        dataMaps.assertReadAccess();
        return dataMaps.getGroupNodeDataMap().get(groupNode);
    }

    @Nullable
    public static <N, E> Node getGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull NodeGroupDescriptor groupDescriptor) {
        if (dataMaps == null) {
            GraphImplUtil.v(51);
        }
        if (groupDescriptor == null) {
            GraphImplUtil.v(52);
        }
        dataMaps.assertReadAccess();
        Map<Node, NodeGroupDescriptor> map = dataMaps.getGroupNodeDataMap();
        return (Node)ContainerUtil.find(map.keySet(), node -> map.get(node) == groupDescriptor);
    }

    @Nullable
    public static <N, E> Edge getCollapsedEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull CollapsedEdge collapsedEdge) {
        if (dataMaps == null) {
            GraphImplUtil.v(53);
        }
        if (collapsedEdge == null) {
            GraphImplUtil.v(54);
        }
        dataMaps.assertReadAccess();
        Map<Edge, CollapsedEdge> map = dataMaps.getCollapsedEdgeDataMap();
        return (Edge)ContainerUtil.find(map.keySet(), edge -> map.get(edge) == collapsedEdge);
    }

    @NotNull
    private static <N, E> Node v(@NotNull HierarchyManager hierarchyManager, @NotNull Graph2D graph2D, @NotNull NodeGroupDescriptor nodeGroupDescriptor, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (hierarchyManager == null) {
            GraphImplUtil.v(55);
        }
        if (graph2D == null) {
            GraphImplUtil.v(56);
        }
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.v(57);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.v(58);
        }
        graphDataMaps.assertWriteAccess();
        return GraphImplUtil.v(hierarchyManager, graph2D, nodeGroupDescriptor, null, graphDataMaps);
    }

    @NotNull
    private static <N, E> Node v(@NotNull HierarchyManager hierarchyManager, @NotNull Graph2D graph2D, @NotNull NodeGroupDescriptor nodeGroupDescriptor, @Nullable Node node, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (hierarchyManager == null) {
            GraphImplUtil.v(59);
        }
        if (graph2D == null) {
            GraphImplUtil.v(60);
        }
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.v(61);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.v(62);
        }
        graphDataMaps.assertWriteAccess();
        Node node2 = node != null ? hierarchyManager.createGroupNode(node) : hierarchyManager.createGroupNode((Graph)graph2D);
        graph2D.setLabelText(node2, nodeGroupDescriptor.getGroupName());
        graphDataMaps.getGroupNodeDataMap().put(node2, nodeGroupDescriptor);
        Node node3 = node2;
        if (node3 == null) {
            GraphImplUtil.v(63);
        }
        return node3;
    }

    @Nullable
    private static <N, E> Node v(@NotNull Graph2D graph2D, @NotNull NodeGroupDescriptor nodeGroupDescriptor, @NotNull HierarchyManager hierarchyManager, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (graph2D == null) {
            GraphImplUtil.v(64);
        }
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.v(65);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.v(66);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.v(67);
        }
        graphDataMaps.assertReadAccess();
        for (Node node : graph2D.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node) && !hierarchyManager.isGroupNode(node)) continue;
            if (nodeGroupDescriptor.equals(GraphImplUtil.getGroupNode(graphDataMaps, node))) {
                return node;
            }
            Node node2 = GraphImplUtil.v(nodeGroupDescriptor, hierarchyManager, hierarchyManager.getChildren(node), graphDataMaps);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    @Nullable
    private static <N, E> Node v(@NotNull NodeGroupDescriptor nodeGroupDescriptor, @NotNull HierarchyManager hierarchyManager, @NotNull NodeCursor nodeCursor, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.v(68);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.v(69);
        }
        if (nodeCursor == null) {
            GraphImplUtil.v(70);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.v(71);
        }
        graphDataMaps.assertReadAccess();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (nodeGroupDescriptor.equals(GraphImplUtil.getGroupNode(graphDataMaps, node))) {
                return node;
            }
            Node node2 = GraphImplUtil.v(nodeGroupDescriptor, hierarchyManager, hierarchyManager.getChildren(node), graphDataMaps);
            if (node2 != null) {
                return node2;
            }
            nodeCursor.next();
        }
        return null;
    }

    @Nullable
    public static <N, E> NodeGroupDescriptor getGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.v(72);
        }
        if (node == null) {
            GraphImplUtil.v(73);
        }
        dataMaps.assertReadAccess();
        return dataMaps.getGroupNodeDataMap().get(node);
    }

    public static <N, E> boolean isGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.v(74);
        }
        if (node == null) {
            GraphImplUtil.v(75);
        }
        dataMaps.assertReadAccess();
        return dataMaps.getGroupNodeDataMap().get(node) != null;
    }

    public static <N, E> void setEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge, @NotNull E edgeObject) {
        if (dataMaps == null) {
            GraphImplUtil.v(76);
        }
        if (edge == null) {
            GraphImplUtil.v(77);
        }
        if (edgeObject == null) {
            GraphImplUtil.v(78);
        }
        dataMaps.assertWriteAccess();
        dataMaps.getEdgeObjectDataBiMap().forcePut((Object)edge, edgeObject);
    }

    @Nullable
    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E e2) {
        if (dataMaps == null) {
            GraphImplUtil.v(79);
        }
        if (e2 == null) {
            GraphImplUtil.v(80);
        }
        dataMaps.assertReadAccess();
        return dataMaps.getEdgeNameDataMap().get(GraphImplUtil.getEdge(dataMaps, e2));
    }

    @NotNull
    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        if (dataMaps == null) {
            GraphImplUtil.v(81);
        }
        if (edge == null) {
            GraphImplUtil.v(82);
        }
        dataMaps.assertReadAccess();
        String string = dataMaps.getEdgeNameDataMap().get(edge);
        String string2 = string == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.v(83);
        }
        return string2;
    }

    public static <N, E> void setEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge, @NotNull String name) {
        if (dataMaps == null) {
            GraphImplUtil.v(84);
        }
        if (edge == null) {
            GraphImplUtil.v(85);
        }
        if (name == null) {
            GraphImplUtil.v(86);
        }
        dataMaps.assertWriteAccess();
        dataMaps.getEdgeNameDataMap().put(edge, name);
    }

    @NotNull
    public static <N, E> Edge createEdge(@NotNull Graph2D graph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (graph == null) {
            GraphImplUtil.v(87);
        }
        if (dataMaps == null) {
            GraphImplUtil.v(88);
        }
        if (node1 == null) {
            GraphImplUtil.v(89);
        }
        if (node2 == null) {
            GraphImplUtil.v(90);
        }
        if (name == null) {
            GraphImplUtil.v(91);
        }
        if (equalityObjects == null) {
            GraphImplUtil.v(92);
        }
        dataMaps.assertWriteAccess();
        Edge edge = graph.createEdge(node1, node2);
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        dataMaps.getEdgeEqualityDataMap().put((Object)edge, (Object)GraphImplUtil.v(dataMaps, name, node1, node2, equalityObjects));
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphImplUtil.v(93);
        }
        return edge2;
    }

    @NotNull
    public static <N, E> Edge createEdge(@NotNull HierarchyManager hierarchyManager, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (hierarchyManager == null) {
            GraphImplUtil.v(94);
        }
        if (dataMaps == null) {
            GraphImplUtil.v(95);
        }
        if (node1 == null) {
            GraphImplUtil.v(96);
        }
        if (node2 == null) {
            GraphImplUtil.v(97);
        }
        if (name == null) {
            GraphImplUtil.v(98);
        }
        if (equalityObjects == null) {
            GraphImplUtil.v(99);
        }
        dataMaps.assertWriteAccess();
        Edge edge = hierarchyManager.createEdge(node1, node2);
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        dataMaps.getEdgeEqualityDataMap().put((Object)edge, (Object)GraphImplUtil.v(dataMaps, name, node1, node2, equalityObjects));
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphImplUtil.v(100);
        }
        return edge2;
    }

    @NotNull
    public static <N, E> Edge createCollapsedEdge(@NotNull HierarchyManager hierarchyManager, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull CollapsedEdge collapsedEdge, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (hierarchyManager == null) {
            GraphImplUtil.v(101);
        }
        if (dataMaps == null) {
            GraphImplUtil.v(102);
        }
        if (collapsedEdge == null) {
            GraphImplUtil.v(103);
        }
        if (name == null) {
            GraphImplUtil.v(104);
        }
        if (equalityObjects == null) {
            GraphImplUtil.v(105);
        }
        dataMaps.assertWriteAccess();
        Edge edge = hierarchyManager.createEdge(collapsedEdge.getSource(), collapsedEdge.getTarget());
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphImplUtil.v(106);
        }
        return edge2;
    }

    @Nullable
    public static <N, E> N getNodeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.v(107);
        }
        if (node == null) {
            GraphImplUtil.v(108);
        }
        dataMaps.assertReadAccess();
        return (N)dataMaps.getNodeObjectDataBiMap().get((Object)node);
    }

    @Nullable
    public static <N, E> E getEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        if (dataMaps == null) {
            GraphImplUtil.v(109);
        }
        if (edge == null) {
            GraphImplUtil.v(110);
        }
        dataMaps.assertReadAccess();
        return (E)dataMaps.getEdgeObjectDataBiMap().get((Object)edge);
    }

    @Nullable
    public static <N, E> NodeGroupDescriptor getGroupNodeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.v(111);
        }
        if (node == null) {
            GraphImplUtil.v(112);
        }
        dataMaps.assertReadAccess();
        return dataMaps.getGroupNodeDataMap().get(node);
    }

    @Nullable
    public static <N, E> CollapsedEdge getCollapsedEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        if (dataMaps == null) {
            GraphImplUtil.v(113);
        }
        if (edge == null) {
            GraphImplUtil.v(114);
        }
        dataMaps.assertReadAccess();
        return dataMaps.getCollapsedEdgeDataMap().get(edge);
    }

    @Nullable
    public static <N, E> Node getNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull N node) {
        if (dataMaps == null) {
            GraphImplUtil.v(115);
        }
        if (node == null) {
            GraphImplUtil.v(116);
        }
        dataMaps.assertReadAccess();
        return (Node)dataMaps.getNodeObjectDataBiMap().inverse().get(node);
    }

    @Nullable
    public static <N, E> Edge getEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E edge) {
        if (dataMaps == null) {
            GraphImplUtil.v(117);
        }
        if (edge == null) {
            GraphImplUtil.v(118);
        }
        dataMaps.assertReadAccess();
        return (Edge)dataMaps.getEdgeObjectDataBiMap().inverse().get(edge);
    }

    public static <N, E> void setNodeWasDragged(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.v(119);
        }
        if (node == null) {
            GraphImplUtil.v(120);
        }
        dataMaps.assertWriteAccess();
        dataMaps.getDraggedNodesList().add(node);
    }

    @Nullable
    private static <N, E> ComparableNode S(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node) {
        if (graphDataMaps == null) {
            GraphImplUtil.v(121);
        }
        if (node == null) {
            GraphImplUtil.v(122);
        }
        graphDataMaps.assertReadAccess();
        return (ComparableNode)graphDataMaps.getNodeEqualityDataMap().get((Object)node);
    }

    @NotNull
    public static List<NodeLabel> getNodeLabels(@Nullable NodeRealizer nodeRealizer) {
        if (nodeRealizer == null) {
            List<NodeLabel> list = Collections.emptyList();
            if (list == null) {
                GraphImplUtil.v(123);
            }
            return list;
        }
        int n2 = nodeRealizer.labelCount();
        ArrayList<NodeLabel> arrayList = new ArrayList<NodeLabel>();
        for (int i10 = 0; i10 < n2; ++i10) {
            arrayList.add(nodeRealizer.getLabel(i10));
        }
        ArrayList<NodeLabel> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.v(124);
        }
        return arrayList2;
    }

    @NotNull
    public static List<EdgeLabel> getEdgeLabels(@Nullable EdgeRealizer edgeRealizer) {
        if (edgeRealizer == null) {
            List<EdgeLabel> list = Collections.emptyList();
            if (list == null) {
                GraphImplUtil.v(125);
            }
            return list;
        }
        int n2 = edgeRealizer.labelCount();
        ArrayList<EdgeLabel> arrayList = new ArrayList<EdgeLabel>();
        for (int i10 = 0; i10 < n2; ++i10) {
            arrayList.add(edgeRealizer.getLabel(i10));
        }
        ArrayList<EdgeLabel> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.v(126);
        }
        return arrayList2;
    }

    @Deprecated
    @NotNull
    public static <N, E> Node getOrCreateGroupNode(@NotNull Graph2D graph, @NotNull HierarchyManager hierarchyManager, @NotNull NodeGroupDescriptor groupDescriptor, @NotNull GraphDataMaps<N, E> dataMaps) {
        if (graph == null) {
            GraphImplUtil.v(127);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.v(128);
        }
        if (groupDescriptor == null) {
            GraphImplUtil.v(129);
        }
        if (dataMaps == null) {
            GraphImplUtil.v(130);
        }
        dataMaps.assertGraphThread();
        return GraphImplUtil.getOrCreateGroupNode(graph, hierarchyManager, groupDescriptor, dataMaps, null);
    }

    private static /* synthetic */ void v(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 9, 11, 20, 32, 46, 47, 48, 63, 83, 93, 100, 106, 123, 124, 125, 126 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataMaps";
                break;
            }
            case 1: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 35: 
            case 86: 
            case 91: 
            case 98: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 19: 
            case 22: 
            case 27: 
            case 92: 
            case 99: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityObjects";
                break;
            }
            case 4: 
            case 89: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 5: 
            case 90: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 23: 
            case 41: 
            case 56: 
            case 60: 
            case 64: 
            case 87: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 63: 
            case 83: 
            case 93: 
            case 100: 
            case 106: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGraph";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 31: 
            case 34: 
            case 37: 
            case 39: 
            case 73: 
            case 75: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject";
                break;
            }
            case 40: 
            case 42: 
            case 55: 
            case 59: 
            case 66: 
            case 69: 
            case 94: 
            case 101: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyManager";
                break;
            }
            case 43: 
            case 52: 
            case 61: 
            case 65: 
            case 68: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDescriptor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
            case 54: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collapsedEdge";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 77: 
            case 82: 
            case 85: 
            case 110: 
            case 114: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeObject";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateGroupNode";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupNode";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 93: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapsedEdge";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLabels";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeLabels";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExistedNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExistedEdge";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 63: 
            case 83: 
            case 93: 
            case 100: 
            case 106: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEdges";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createComparableNode";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createComparableEdge";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getComparableNode";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setNodeName";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setNodeObject";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "expandAllParentNodes";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGroupNode";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 51: 
            case 52: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getGroupNode";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedEdge";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNode";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNode";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenGroupNode";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isGroupNode";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeObject";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeName";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeName";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createCollapsedEdge";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getNodeObject";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeObject";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getGroupNodeObject";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedEdgeObject";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getEdge";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "setNodeWasDragged";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getNodeComparableObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 20, 32, 46, 47, 48, 63, 83, 93, 100, 106, 123, 124, 125, 126 -> new IllegalStateException(string);
        };
    }
}

