/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.impl.LspDidChangeUtil;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/lsp/impl/LspDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "LspDocumentListener", "()V", "documentsToHandle", "", "Lcom/intellij/openapi/editor/Document;", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "v", "ChangedFilesData", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDocumentListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDocumentListener.kt\ncom/intellij/platform/lsp/impl/LspDocumentListener\n+ 2 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n300#2:167\n301#2:169\n302#2,2:171\n304#2:174\n300#2:176\n301#2:178\n302#2,2:180\n304#2:183\n300#2:185\n301#2:187\n302#2,2:189\n304#2:192\n13472#3:168\n13473#3:175\n13472#3:177\n13473#3:184\n13472#3:186\n13473#3:193\n1869#4:170\n1870#4:173\n1869#4:179\n1870#4:182\n1869#4:188\n1870#4:191\n1869#4,2:194\n*S KotlinDebug\n*F\n+ 1 LspDocumentListener.kt\ncom/intellij/platform/lsp/impl/LspDocumentListener\n*L\n42#1:167\n42#1:169\n42#1:171,2\n42#1:174\n61#1:176\n61#1:178\n61#1:180,2\n61#1:183\n82#1:185\n82#1:187\n82#1:189,2\n82#1:192\n42#1:168\n42#1:175\n61#1:177\n61#1:184\n82#1:186\n82#1:193\n42#1:170\n42#1:173\n61#1:179\n61#1:182\n82#1:188\n82#1:191\n106#1:194,2\n*E\n"})
public final class LspDocumentListener
implements DocumentListener {
    @NotNull
    private final Set<Document> documentsToHandle;

    public LspDocumentListener() {
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.documentsToHandle = set;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = LspDidChangeUtil.INSTANCE.getFileToHandle(event);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        LspServerManagerImpl.Companion companion = LspServerManagerImpl.Companion;
        boolean bl = false;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] objectArray = projectArray;
        boolean bl2 = false;
        for (Object object : objectArray) {
            Project project = (Project)object;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)project);
            Iterable iterable = LspServerManagerImpl.access$getLspServers$p(LspServerManagerImpl.Companion.getInstanceImpl(project));
            boolean bl4 = false;
            for (Object t2 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl5 = false;
                if (lspServerImpl.getState() != LspServerState.Running) continue;
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl6 = false;
                lspServerImpl2.fileEdited$intellij_platform_lsp_impl(virtualFile2, event);
                if (lspServerImpl2.getTextDocumentSyncKind$intellij_platform_lsp_impl() != TextDocumentSyncKind.Incremental || !lspServerImpl2.isFileOpened$intellij_platform_lsp_impl(virtualFile2)) continue;
                DidChangeTextDocumentParams didChangeTextDocumentParams = LspDidChangeUtil.INSTANCE.createIncrementalDidChangeParamsBeforeDocumentChange(lspServerImpl2, event, virtualFile2);
                lspServerImpl2.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspDocumentListener.v(didChangeTextDocumentParams, arg_0)));
            }
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = LspDidChangeUtil.INSTANCE.getFileToHandle(event);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        LspServerManagerImpl.Companion companion = LspServerManagerImpl.Companion;
        boolean bl = false;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] objectArray = projectArray;
        boolean bl2 = false;
        for (Object object : objectArray) {
            Project project = (Project)object;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)project);
            Iterable iterable = LspServerManagerImpl.access$getLspServers$p(LspServerManagerImpl.Companion.getInstanceImpl(project));
            boolean bl4 = false;
            for (Object t2 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl5 = false;
                if (lspServerImpl.getState() != LspServerState.Running) continue;
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl6 = false;
                if (lspServerImpl2.getTextDocumentSyncKind$intellij_platform_lsp_impl() != TextDocumentSyncKind.Full || !lspServerImpl2.isFileOpened$intellij_platform_lsp_impl(virtualFile2)) continue;
                LspServer lspServer = lspServerImpl2;
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                DidChangeTextDocumentParams didChangeTextDocumentParams = LspDidChangeUtil.INSTANCE.createFullDidChangeParams$intellij_platform_lsp_impl(lspServer, document, virtualFile2);
                lspServerImpl2.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspDocumentListener.S(didChangeTextDocumentParams, arg_0)));
            }
        }
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.documentsToHandle.add(document);
        this.v();
    }

    private final void v() {
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> LspDocumentListener.v(this)).coalesceBy(objectArray).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspDocumentListener.v(arg_0 -> LspDocumentListener.v(this, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final Unit v(DidChangeTextDocumentParams didChangeTextDocumentParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getTextDocumentService().didChange(didChangeTextDocumentParams);
        return Unit.INSTANCE;
    }

    private static final Unit S(DidChangeTextDocumentParams didChangeTextDocumentParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getTextDocumentService().didChange(didChangeTextDocumentParams);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ChangedFilesData v(LspDocumentListener lspDocumentListener) {
        boolean bl;
        ChangedFilesData changedFilesData = new ChangedFilesData();
        Object object = lspDocumentListener.documentsToHandle;
        synchronized (object) {
            bl = false;
            bl = changedFilesData.getHandledDocuments().addAll((Collection<Document>)lspDocumentListener.documentsToHandle);
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        object = LspServerManagerImpl.Companion;
        bl = false;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] objectArray = projectArray;
        boolean bl2 = false;
        for (Object object2 : objectArray) {
            Project project = (Project)object2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)project);
            Iterable iterable = LspServerManagerImpl.access$getLspServers$p(LspServerManagerImpl.Companion.getInstanceImpl(project));
            boolean bl4 = false;
            for (Object t2 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl5 = false;
                if (lspServerImpl.getState() != LspServerState.Running) continue;
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl6 = false;
                for (Document document : changedFilesData.getHandledDocuments()) {
                    VirtualFile virtualFile;
                    ProgressManager.checkCanceled();
                    if (!fileDocumentManager2.isDocumentUnsaved(document) || fileDocumentManager2.getFile(document) == null || !virtualFile.isInLocalFileSystem() || lspServerImpl2.isFileOpened$intellij_platform_lsp_impl(virtualFile) || !lspServerImpl2.isSupportedFile$intellij_platform_lsp_impl(virtualFile)) continue;
                    changedFilesData.getServersToSendDidOpen().add((Pair<LspServerImpl, VirtualFile>)TuplesKt.to((Object)lspServerImpl2, (Object)virtualFile));
                }
            }
        }
        return changedFilesData;
    }

    private static final void v(ChangedFilesData changedFilesData) {
        Iterable iterable = changedFilesData.getServersToSendDidOpen();
        boolean bl = false;
        for (Object t2 : iterable) {
            Pair pair = (Pair)t2;
            boolean bl2 = false;
            ((LspServerImpl)pair.getFirst()).sendDidOpenRequest$intellij_platform_lsp_impl((VirtualFile)pair.getSecond());
        }
    }

    private static final Unit v(LspDocumentListener lspDocumentListener, ChangedFilesData changedFilesData) {
        Intrinsics.checkNotNullParameter((Object)changedFilesData, (String)"data");
        lspDocumentListener.documentsToHandle.removeAll((Collection)changedFilesData.getHandledDocuments());
        if (changedFilesData.getServersToSendDidOpen().isEmpty()) {
            return Unit.INSTANCE;
        }
        WriteAction.run(() -> LspDocumentListener.v(changedFilesData));
        return Unit.INSTANCE;
    }

    private static final void v(Function1 function1, Object object) {
        function1.invoke(object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/lsp/impl/LspDocumentListener$ChangedFilesData;", "", "LspDocumentListener$ChangedFilesData", "()V", "handledDocuments", "", "Lcom/intellij/openapi/editor/Document;", "getHandledDocuments", "()Ljava/util/Set;", "serversToSendDidOpen", "", "Lkotlin/Pair;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getServersToSendDidOpen", "()Ljava/util/Collection;", "intellij.platform.lsp.impl"})
    private static final class ChangedFilesData {
        @NotNull
        private final Set<Document> handledDocuments = new HashSet();
        @NotNull
        private final Collection<Pair<LspServerImpl, VirtualFile>> serversToSendDidOpen = new ArrayList();

        @NotNull
        public final Set<Document> getHandledDocuments() {
            return this.handledDocuments;
        }

        @NotNull
        public final Collection<Pair<LspServerImpl, VirtualFile>> getServersToSendDidOpen() {
            return this.serversToSendDidOpen;
        }
    }
}

