/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEventListener;
import com.intellij.ml.inline.completion.impl.diagnostic.TextMessage;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001$B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ-\u0010\n\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012JA\u0010\u0013\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\f\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\tJ\u0014\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\tJ\u0014\u0010\"\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "featureType", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger$FeatureType;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger$FeatureType;)V", "formatMessage", "", "logActionTime", "", "actionName", "actionTimeMs", "", "T", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "logActionTimeAndReport", "reportAction", "Lkotlin/Function1;", "Lkotlin/time/Duration;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "errorIfNotMessage", "", "throwable", "", "error", "text", "debug", "lazyText", "info", "warn", "trace", "sendTextMessage", "FeatureType", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\ndiagnosticLoggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,504:1\n95#2:505\n135#2,3:506\n95#2:509\n135#2,3:510\n*S KotlinDebug\n*F\n+ 1 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger\n*L\n106#1:505\n106#1:506,3\n115#1:509\n115#1:510,3\n*E\n"})
public final class MLCompletionLogger {
    @NotNull
    private final Logger log;
    @NotNull
    private final FeatureType featureType;

    @ApiStatus.Internal
    public MLCompletionLogger(@NotNull Logger log, @NotNull FeatureType featureType) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)((Object)featureType), (String)"featureType");
        this.log = log;
        this.featureType = featureType;
    }

    private final String formatMessage(String $this$formatMessage) {
        return "[" + this.featureType.name() + "] " + $this$formatMessage;
    }

    public final void logActionTime(@NotNull String actionName, long actionTimeMs) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        this.debug("'" + actionName + "' took " + actionTimeMs + "ms");
    }

    public final <T> T logActionTime(@NotNull String actionName, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$logActionTime = false;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Object result$iv$iv = action2.invoke();
        TimedValue timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Object value = timedValue.component1();
        long time = timedValue.component2-UwyO8pc();
        this.logActionTime(actionName, Duration.getInWholeMilliseconds-impl((long)time));
        return (T)value;
    }

    public final <T> T logActionTimeAndReport(@NotNull String actionName, @NotNull Function1<? super Duration, Unit> reportAction, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(reportAction, (String)"reportAction");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$logActionTimeAndReport = false;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Object result$iv$iv = action2.invoke();
        TimedValue timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Object value = timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        this.logActionTime(actionName, Duration.getInWholeMilliseconds-impl((long)duration));
        reportAction.invoke((Object)Duration.box-impl((long)duration));
        return (T)value;
    }

    public final boolean errorIfNotMessage(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        boolean errorLogged = Promises.errorIfNotMessage((Logger)this.log, (Throwable)throwable);
        if (errorLogged) {
            this.sendTextMessage(throwable.toString());
        }
        return errorLogged;
    }

    public final void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.error(this.formatMessage(""), throwable);
        this.sendTextMessage(throwable.toString());
    }

    public final void error(@NotNull String text2, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.error(this.formatMessage(text2), throwable);
        this.sendTextMessage(text2);
    }

    public final void error(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.error(this.formatMessage(text2));
        this.sendTextMessage(text2);
    }

    public final void debug(@NotNull Function0<String> lazyText) {
        Intrinsics.checkNotNullParameter(lazyText, (String)"lazyText");
        this.debug((String)lazyText.invoke());
    }

    public final void debug(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.formatMessage(text2));
        }
        this.sendTextMessage(text2);
    }

    public final void info(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.info(this.formatMessage(text2));
        this.sendTextMessage(text2);
    }

    public final void warn(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.warn(this.formatMessage(text2));
        this.sendTextMessage(text2);
    }

    public final void warn(@NotNull String text2, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.warn(this.formatMessage(text2), throwable);
        this.sendTextMessage(text2);
    }

    public final void trace(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.trace(this.formatMessage(text2));
        this.sendTextMessage(text2);
    }

    public final void trace(@NotNull Function0<String> lazyText) {
        Intrinsics.checkNotNullParameter(lazyText, (String)"lazyText");
        if (this.log.isTraceEnabled()) {
            this.trace((String)lazyText.invoke());
        }
    }

    private final void sendTextMessage(String text2) {
        if (!DiagnosticLoggersKt.access$getDispatcher$p().hasListeners()) {
            return;
        }
        TextMessage message = new TextMessage(text2, System.currentTimeMillis(), this.featureType);
        ((MLCompletionEventListener)DiagnosticLoggersKt.access$getDispatcher$p().getMulticaster()).onEvent(message);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger$FeatureType;", "", "<init>", "(Ljava/lang/String;I)V", "Completion", "NextEdit", "intellij.fullLine.core.completion"})
    public static final class FeatureType
    extends Enum<FeatureType> {
        public static final /* enum */ FeatureType Completion = new FeatureType();
        public static final /* enum */ FeatureType NextEdit = new FeatureType();
        private static final /* synthetic */ FeatureType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FeatureType[] values() {
            return (FeatureType[])$VALUES.clone();
        }

        public static FeatureType valueOf(String value) {
            return Enum.valueOf(FeatureType.class, value);
        }

        @NotNull
        public static EnumEntries<FeatureType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = featureTypeArray = new FeatureType[]{FeatureType.Completion, FeatureType.NextEdit};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

