/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonDependency;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleMapping;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitutionImpl;
import com.intellij.lang.javascript.linter.JSLinterExecutionSuppressor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCachedValue;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowablePairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageJsonData {
    private static final Logger LOG = Logger.getInstance(PackageJsonData.class);
    private static final Key<VirtualFileCachedValue<PackageJsonData>> CACHED_PACKAGE_JSON_DATA_KEY = Key.create((String)"js.cached.package-json.data");
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String DESCRIPTION = "description";
    private static final String JSNEXT_MAIN = "jsnext:main";
    private static final String ESNEXT = "esnext";
    private static final String MODULE = "module";
    private static final String TYPE = "type";
    private static final String ES2015 = "es2015";
    private static final String BROWSER = "browser";
    private static final String CDN = "cdn";
    private static final String JSDELIVR = "jsdelivr";
    private static final String MAIN = "main";
    private static final String WEB_TYPES = "web-types";
    private static final String CUSTOM_ELEMENTS = "customElements";
    private static final String IMPORTS = "imports";
    private static final String EXPORTS = "exports";
    private static final String BIN = "bin";
    private static final String WORKSPACES = "workspaces";
    private static final String TYPES_VERSIONS = "typesVersions";
    private static final List<String> JS_NEXT_MAINS = List.of("exports", "esnext", "module", "es2015", "jsnext:main");
    private static final Map<String, BiConsumer<Holder, String>> ourParsers = Map.ofEntries(Map.entry("name", (holder, value) -> {
        holder.myName = value;
    }), Map.entry("main", (holder, value) -> {
        holder.myMain = value;
    }), Map.entry("description", (holder, value) -> {
        holder.myDescription = value;
    }), Map.entry("version", (holder, value) -> {
        holder.myVersion = value;
    }), Map.entry("types", (holder, value) -> {
        holder.myTypings = value;
    }), Map.entry("typings", (holder, value) -> {
        holder.myTypings = value;
    }), Map.entry("type", (holder, value) -> {
        holder.myType = value;
    }), Map.entry("jsnext:main", (holder, value) -> holder.additionalMainProperties.put(JSNEXT_MAIN, (String)value)), Map.entry("module", (holder, value) -> holder.additionalMainProperties.put(MODULE, (String)value)), Map.entry("es2015", (holder, value) -> holder.additionalMainProperties.put(ES2015, (String)value)), Map.entry("browser", (holder, value) -> holder.additionalMainProperties.put(BROWSER, (String)value)), Map.entry("cdn", (holder, value) -> holder.additionalMainProperties.put(CDN, (String)value)), Map.entry("jsdelivr", (holder, value) -> holder.additionalMainProperties.put(JSDELIVR, (String)value)), Map.entry("tsconfig", (holder, value) -> {
        holder.myTsConfig = value;
    }), Map.entry("customElements", (holder, value) -> {
        holder.myCustomElements = value;
    }));
    private static final Map<String, ThrowablePairConsumer<Holder, JsonReader, IOException>> ourCustomParsers = Map.ofEntries(Map.entry("bin", (holder, reader) -> {
        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
            reader.beginObject();
            holder.myBinMap = new HashMap<String, String>(1);
            while (reader.hasNext()) {
                String name = reader.nextName();
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                if (name == null || value == null) continue;
                holder.myBinMap.put(name, value);
            }
            reader.endObject();
        } else {
            holder.myBinMap = Collections.singletonMap(null, JsonUtil.nextStringOrSkip((JsonReader)reader));
        }
    }), Map.entry("workspaces", (holder, reader) -> {
        holder.myWorkspaces = PackageJsonData.parseWorkspaces(reader);
    }), Map.entry("esnext", (holder, reader) -> {
        JsonToken tokenType = reader.peek();
        String value = tokenType == JsonToken.BEGIN_OBJECT ? JsonUtil.getChildAsString((JsonReader)reader, (String)MAIN, null) : JsonUtil.nextStringOrSkip((JsonReader)reader);
        if (value != null) {
            holder.additionalMainProperties.put(ESNEXT, value);
        }
    }), Map.entry("typesVersions", (holder, reader) -> {
        holder.myTypingsVersionMappings = PackageJsonData.parseTypingsVersionMappings(reader);
    }), Map.entry("web-types", (holder, reader) -> {
        holder.myWebTypes = PackageJsonData.parseWebTypes(reader);
    }), Map.entry("imports", (holder, reader) -> {
        holder.myImports = PackageJsonData.parseImports(reader);
    }), Map.entry("exports", PackageJsonData::applyExportsToHolder));
    private final VirtualFile myPackageJsonFile;
    private final String myName;
    private final String myMain;
    private final String myType;
    private final String typings;
    private final String myDescription;
    private final Map<String, String> myBinMap;
    private final SemVer myVersion;
    private final Map<String, PackageJsonDependencyEntry> myDependencyMap;
    private final Map<String, @NotNull String> additionalMainProperties;
    private final Set<String> myScopes;
    private final Set<String> topLevelProperties;
    @Nullable
    private final List<String> myWorkspaces;
    private final String myTsConfig;
    private final List<String> myWebTypes;
    private final String myCustomElements;
    private final JSModulePathMappings<JSModulePathSubstitution> myImports;
    private final JSModulePathMappings<JSModulePathSubstitution> myExports;
    @NotNull
    private final Map<String, JSModulePathMappings<JSModulePathSubstitution>> typingsVersionMappings;

    private static void applyExportsToHolder(@NotNull Holder holder, @NotNull JsonReader reader) {
        JsonElement element2;
        if (holder == null) {
            PackageJsonData.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(1);
        }
        if ((element2 = JsonParser.parseReader((JsonReader)reader)).isJsonPrimitive()) {
            String value = element2.getAsString();
            if (value != null) {
                holder.additionalMainProperties.put(EXPORTS, value);
            }
        } else if (element2.isJsonObject()) {
            List<JSModulePathSubstitution> exports = PackageJsonData.parseImportsExportsMappings(element2);
            Collection<JSModuleMapping> topLevelMappings = PackageJsonData.getMappingsFromConditionalExports(element2.getAsJsonObject(), Collections.emptyList());
            ArrayList<@NotNull JSModulePathSubstitution> builder2 = new ArrayList<JSModulePathSubstitution>(exports.size() + (topLevelMappings.isEmpty() ? 0 : 1));
            builder2.addAll(exports);
            if (!topLevelMappings.isEmpty()) {
                builder2.add(new JSModulePathSubstitutionImpl(".", topLevelMappings));
            }
            holder.exports = builder2;
            if (topLevelMappings.size() == 1) {
                holder.additionalMainProperties.put(EXPORTS, ((JSModuleMapping)ContainerUtil.getFirstItem(topLevelMappings)).getMapping());
            }
        }
    }

    @NotNull
    private static List<JSModulePathSubstitution> parseImports(@NotNull JsonReader reader) {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(2);
        }
        return PackageJsonData.parseImportsExportsMappings(JsonParser.parseReader((JsonReader)reader));
    }

    @NotNull
    private static List<JSModulePathSubstitution> parseImportsExportsMappings(@NotNull JsonElement element2) {
        if (element2 == null) {
            PackageJsonData.$$$reportNull$$$0(3);
        }
        if (!(element2 instanceof JsonObject)) {
            List<JSModulePathSubstitution> list = Collections.emptyList();
            if (list == null) {
                PackageJsonData.$$$reportNull$$$0(4);
            }
            return list;
        }
        JsonObject object = element2.getAsJsonObject();
        SmartList mappings = new SmartList();
        for (Map.Entry entry : object.entrySet()) {
            Collection<JSModuleMapping> fromConditions;
            String name = (String)entry.getKey();
            if (PackageJsonData.isConditionalExport(name)) continue;
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonPrimitive()) {
                JSModuleMapping mapping = new JSModuleMapping(value.getAsString());
                if (!Strings.isNotEmpty((String)mapping.getMapping())) continue;
                mappings.add((Object)new JSModulePathSubstitutionImpl(Strings.trimStart((String)name, (String)"./"), mapping));
                continue;
            }
            if (value.isJsonArray()) {
                List nested = JsonUtil.getAsStringList((JsonElement)value);
                if (nested == null || nested.isEmpty()) continue;
                mappings.add((Object)new JSModulePathSubstitutionImpl(Strings.trimStart((String)name, (String)"./"), ContainerUtil.map((Collection)nested, JSModuleMapping::new)));
                continue;
            }
            if (!value.isJsonObject() || (fromConditions = PackageJsonData.getMappingsFromConditionalExports(value.getAsJsonObject(), Collections.emptyList())).isEmpty()) continue;
            mappings.add((Object)new JSModulePathSubstitutionImpl(Strings.trimStart((String)name, (String)"./"), fromConditions));
        }
        SmartList smartList = mappings;
        if (smartList == null) {
            PackageJsonData.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @NotNull
    private static Collection<JSModuleMapping> getMappingsFromConditionalExports(@NotNull JsonObject element2, @NotNull List<JSModuleMapping.Condition> conditions) {
        if (element2 == null) {
            PackageJsonData.$$$reportNull$$$0(6);
        }
        if (conditions == null) {
            PackageJsonData.$$$reportNull$$$0(7);
        }
        SmartList results = new SmartList();
        for (Map.Entry entry : element2.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (!PackageJsonData.isConditionalExport(key)) continue;
            JSModuleMapping.Condition condition = JSModuleMapping.getCondition(key);
            List<JSModuleMapping.Condition> finalConditions = conditions;
            if (condition != null) {
                finalConditions = new ArrayList<JSModuleMapping.Condition>(conditions);
                finalConditions.add(condition);
            }
            if (value.isJsonPrimitive()) {
                results.add((Object)new JSModuleMapping(value.getAsString(), finalConditions));
                continue;
            }
            if (value.isJsonArray()) {
                List stringList = JsonUtil.getAsStringList((JsonElement)value);
                if (stringList == null) continue;
                for (String arrayValue : stringList) {
                    results.add((Object)new JSModuleMapping(arrayValue, finalConditions));
                }
                continue;
            }
            if (!value.isJsonObject()) continue;
            results.addAll(PackageJsonData.getMappingsFromConditionalExports(value.getAsJsonObject(), finalConditions));
        }
        SmartList smartList = results;
        if (smartList == null) {
            PackageJsonData.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static boolean isConditionalExport(@NotNull String key) {
        if (key == null) {
            PackageJsonData.$$$reportNull$$$0(9);
        }
        return !key.startsWith("#") && !key.startsWith("./");
    }

    private static List<String> parseWebTypes(JsonReader reader) {
        JsonElement element2 = JsonParser.parseReader((JsonReader)reader);
        String singleValue = JsonUtil.getString((JsonElement)element2);
        if (singleValue != null) {
            return Collections.singletonList(singleValue);
        }
        List list = JsonUtil.getAsStringList((JsonElement)element2);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Map<String, JSModulePathMappings<JSModulePathSubstitution>> parseTypingsVersionMappings(@NotNull JsonReader reader) {
        JsonElement element2;
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(10);
        }
        if (!((element2 = JsonParser.parseReader((JsonReader)reader)) instanceof JsonObject)) {
            Map<String, JSModulePathMappings<JSModulePathSubstitution>> map2 = Collections.emptyMap();
            if (map2 == null) {
                PackageJsonData.$$$reportNull$$$0(11);
            }
            return map2;
        }
        LinkedHashMap<String, JSModulePathMappings<JSModulePathSubstitution>> map3 = new LinkedHashMap<String, JSModulePathMappings<JSModulePathSubstitution>>();
        for (Map.Entry mappingsEntry : ((JsonObject)element2).entrySet()) {
            Set entries;
            JsonElement mappings;
            String version2 = (String)mappingsEntry.getKey();
            if (Strings.isEmpty((String)version2) || !((mappings = (JsonElement)mappingsEntry.getValue()) instanceof JsonObject) || (entries = ((JsonObject)mappings).entrySet()).isEmpty()) continue;
            SmartList list = new SmartList();
            for (Map.Entry mappingEntry : ((JsonObject)mappings).entrySet()) {
                String nestedString;
                JsonElement value;
                List<String> nested;
                String mapping = (String)mappingEntry.getKey();
                if (Strings.isEmpty((String)mapping) || (nested = JsonUtil.getAsStringList((JsonElement)(value = (JsonElement)mappingEntry.getValue()))) == null) continue;
                if (nested.isEmpty() && (nestedString = JsonUtil.getString((JsonElement)value)) != null) {
                    nested = Collections.singletonList(nestedString);
                }
                list.add((Object)new JSModulePathSubstitutionImpl(mapping, ContainerUtil.map((Collection)nested, JSModuleMapping::new)));
            }
            map3.put(version2, JSModulePathMappings.build(list));
        }
        LinkedHashMap<String, JSModulePathMappings<JSModulePathSubstitution>> linkedHashMap = map3;
        if (linkedHashMap == null) {
            PackageJsonData.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    @NotNull
    private static List<String> parseWorkspaces(@NotNull JsonReader reader) {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(13);
        }
        JsonElement element2 = JsonParser.parseReader((JsonReader)reader);
        List result2 = null;
        if (element2 instanceof JsonObject) {
            result2 = JsonUtil.getChildAsStringList((JsonObject)((JsonObject)element2), (String)"packages");
        } else if (element2 instanceof JsonArray) {
            result2 = JsonUtil.getAsStringList((JsonElement)element2);
        }
        List list = ContainerUtil.notNullize((List)result2);
        if (list == null) {
            PackageJsonData.$$$reportNull$$$0(14);
        }
        return list;
    }

    private PackageJsonData(@NotNull VirtualFile packageJsonFile, @NotNull Holder holder) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(15);
        }
        if (holder == null) {
            PackageJsonData.$$$reportNull$$$0(16);
        }
        this.myPackageJsonFile = packageJsonFile;
        this.myName = holder.myName;
        this.myMain = holder.myMain;
        this.myType = holder.myType;
        this.additionalMainProperties = holder.additionalMainProperties;
        this.myDescription = holder.myDescription;
        this.typings = holder.myTypings;
        this.myExports = JSModulePathMappings.build(PackageJsonData.remapWithPackageName(this.myName, holder.exports));
        this.myImports = JSModulePathMappings.build(holder.myImports);
        this.topLevelProperties = holder.topLevelProperties;
        this.myBinMap = PackageJsonData.fixBinaryNameMap(holder.myBinMap, this.myName);
        this.myTsConfig = holder.myTsConfig;
        this.myVersion = SemVer.parseFromText((String)Strings.notNullize((String)holder.myVersion));
        this.myWebTypes = holder.myWebTypes;
        this.myCustomElements = holder.myCustomElements;
        this.myWorkspaces = holder.myWorkspaces != null ? List.copyOf(holder.myWorkspaces) : null;
        HashMap<String, PackageJsonDependencyEntry> dependenciesByName = new HashMap<String, PackageJsonDependencyEntry>();
        HashSet<String> scopes = new HashSet<String>();
        for (Map.Entry<PackageJsonDependency, List<PackageJsonDependencyEntry>> entry : holder.dependenciesByType.entrySet()) {
            for (PackageJsonDependencyEntry dependency : entry.getValue()) {
                String dependencyName = dependency.getName();
                dependenciesByName.put(dependencyName, dependency);
                PackageJsonData.addScope(dependencyName, scopes);
            }
        }
        this.myScopes = Set.copyOf(scopes);
        this.myDependencyMap = dependenciesByName;
        this.typingsVersionMappings = holder.myTypingsVersionMappings;
    }

    @NotNull
    private static List<JSModulePathSubstitution> remapWithPackageName(@Nullable String packageName, @NotNull List<JSModulePathSubstitution> exports) {
        if (exports == null) {
            PackageJsonData.$$$reportNull$$$0(17);
        }
        if (packageName == null || packageName.startsWith("@types/")) {
            List<JSModulePathSubstitution> list = Collections.emptyList();
            if (list == null) {
                PackageJsonData.$$$reportNull$$$0(18);
            }
            return list;
        }
        List list = ContainerUtil.map(exports, el -> {
            String pattern = el.getPattern();
            String newPattern = pattern.equals(".") || pattern.isEmpty() ? packageName : packageName + "/" + pattern;
            return new JSModulePathSubstitutionImpl(newPattern, el.getMappings());
        });
        if (list == null) {
            PackageJsonData.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static Map<String, String> fixBinaryNameMap(@NotNull Map<String, String> binaryNameToPathMap, @Nullable String name) {
        Map.Entry<String, String> entry;
        if (binaryNameToPathMap == null) {
            PackageJsonData.$$$reportNull$$$0(20);
        }
        if (binaryNameToPathMap.size() == 1 && (entry = binaryNameToPathMap.entrySet().iterator().next()).getKey() == null) {
            Map<String, String> map2 = Collections.singletonMap(name, entry.getValue());
            if (map2 == null) {
                PackageJsonData.$$$reportNull$$$0(21);
            }
            return map2;
        }
        return new HashMap<String, String>(binaryNameToPathMap);
    }

    private static void addScope(@NotNull String dependencyName, @NotNull Set<String> scopes) {
        String scope2;
        if (dependencyName == null) {
            PackageJsonData.$$$reportNull$$$0(22);
        }
        if (scopes == null) {
            PackageJsonData.$$$reportNull$$$0(23);
        }
        if ((scope2 = NodeModuleSearchUtil.getScopeByPackageName(dependencyName)) != null) {
            scopes.add(scope2);
        }
    }

    public boolean containsDependencyWithScope(@NotNull String scope2) {
        if (scope2 == null) {
            PackageJsonData.$$$reportNull$$$0(24);
        }
        return this.myScopes.contains(scope2);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public JSModulePathMappings<JSModulePathSubstitution> getImports() {
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings = this.myImports;
        if (jSModulePathMappings == null) {
            PackageJsonData.$$$reportNull$$$0(25);
        }
        return jSModulePathMappings;
    }

    @NotNull
    public JSModulePathMappings<JSModulePathSubstitution> getExports() {
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings = this.myExports;
        if (jSModulePathMappings == null) {
            PackageJsonData.$$$reportNull$$$0(26);
        }
        return jSModulePathMappings;
    }

    @NotNull
    public VirtualFile getPackageJsonFile() {
        VirtualFile virtualFile = this.myPackageJsonFile;
        if (virtualFile == null) {
            PackageJsonData.$$$reportNull$$$0(27);
        }
        return virtualFile;
    }

    @Nullable
    public String getTsConfig() {
        return this.myTsConfig;
    }

    @Nullable
    @NlsSafe
    public String getDescription() {
        return this.myDescription;
    }

    public boolean isModuleType() {
        return MODULE.equals(this.myType);
    }

    @Nullable
    public String getMain() {
        return this.myMain;
    }

    @Nullable
    public String getJsNextMain() {
        for (String mainName : JS_NEXT_MAINS) {
            String candidate = this.additionalMainProperties.get(mainName);
            if (candidate == null || candidate.isBlank()) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public Map<String, JSModulePathMappings<JSModulePathSubstitution>> getTypingsVersionMappings() {
        Map<String, JSModulePathMappings<JSModulePathSubstitution>> map2 = this.typingsVersionMappings;
        if (map2 == null) {
            PackageJsonData.$$$reportNull$$$0(28);
        }
        return map2;
    }

    public Set<String> getTopLevelProperties() {
        return this.topLevelProperties;
    }

    @NotNull
    public @NotNull Collection<@NotNull String> getAdditionalMains() {
        Collection<String> collection = this.additionalMainProperties.values();
        if (collection == null) {
            PackageJsonData.$$$reportNull$$$0(29);
        }
        return collection;
    }

    public boolean hasTypingsProperty() {
        return !Strings.isEmptyOrSpaces((CharSequence)this.typings);
    }

    public boolean hasTypings() {
        return !Strings.isEmptyOrSpaces((CharSequence)this.getTypings());
    }

    @Nullable
    public String getTypings() {
        if (!Strings.isEmptyOrSpaces((CharSequence)this.typings)) {
            return this.typings;
        }
        VirtualFile parent = this.myPackageJsonFile.getParent();
        if (parent == null) {
            return null;
        }
        String main = this.getMain();
        if (main != null) {
            if (TypeScriptUtil.isTypeScriptFile(main)) {
                return main;
            }
            String transformed = Strings.trimStart((String)FileUtilRt.getNameWithoutExtension((String)main), (String)"./");
            String tsMain = PackageJsonData.tryConvertToTypeScript(parent, transformed);
            if (tsMain != null || "index".equals(transformed)) {
                return tsMain;
            }
        }
        return PackageJsonData.tryConvertToTypeScript(parent, "index");
    }

    @Nullable
    private static String tryConvertToTypeScript(@NotNull VirtualFile directory, @NotNull String main) {
        if (directory == null) {
            PackageJsonData.$$$reportNull$$$0(30);
        }
        if (main == null) {
            PackageJsonData.$$$reportNull$$$0(31);
        }
        for (String extension : TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS) {
            String path2 = main + extension;
            VirtualFile candidateFile = directory.findFileByRelativePath(path2);
            if (candidateFile == null) continue;
            return path2;
        }
        return null;
    }

    @Nullable
    public String getDefaultMain() {
        String typings = this.getTypings();
        if (!Strings.isEmptyOrSpaces((CharSequence)typings)) {
            return typings;
        }
        String additionalMain = this.getJsNextMain();
        if (!Strings.isEmptyOrSpaces((CharSequence)additionalMain)) {
            return additionalMain;
        }
        return this.myMain;
    }

    @NotNull
    public Map<String, String> getBinaryNameToPathMap() {
        Map<String, String> map2 = this.myBinMap;
        if (map2 == null) {
            PackageJsonData.$$$reportNull$$$0(32);
        }
        return map2;
    }

    @Nullable
    public String getBinPath(@NotNull String executableName) {
        String value;
        if (executableName == null) {
            PackageJsonData.$$$reportNull$$$0(33);
        }
        String string = value = Objects.equals(this.myName, executableName) ? this.myBinMap.get(null) : null;
        if (value == null) {
            value = this.myBinMap.get(executableName);
        }
        return value;
    }

    @Nullable
    public SemVer getVersion() {
        return this.myVersion;
    }

    @NotNull
    public List<String> getWebTypes() {
        List<String> list = this.myWebTypes;
        if (list == null) {
            PackageJsonData.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    public String getCustomElements() {
        return this.myCustomElements;
    }

    public boolean isDependencyOfAnyType(@NotNull String name) {
        if (name == null) {
            PackageJsonData.$$$reportNull$$$0(35);
        }
        return this.myDependencyMap.containsKey(name);
    }

    public boolean containsOneOfDependencyOfAnyType(String ... names) {
        if (names == null) {
            PackageJsonData.$$$reportNull$$$0(36);
        }
        for (String name : names) {
            if (!this.myDependencyMap.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> getAllDependencies() {
        Set<String> set = this.myDependencyMap.keySet();
        if (set == null) {
            PackageJsonData.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    public Map<String, PackageJsonDependencyEntry> getAllDependencyEntries() {
        Map<String, PackageJsonDependencyEntry> map2 = this.myDependencyMap;
        if (map2 == null) {
            PackageJsonData.$$$reportNull$$$0(38);
        }
        return map2;
    }

    @Nullable
    public List<String> getWorkspaces() {
        return this.myWorkspaces;
    }

    public String toString() {
        return this.myName + "@" + String.valueOf(this.myVersion) + " " + String.valueOf(this.myDependencyMap.keySet());
    }

    @NotNull
    public static PackageJsonData getOrCreateWithPreferredProject(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            PackageJsonData.$$$reportNull$$$0(39);
        }
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(40);
        }
        AccessToken ignored = ProjectLocator.withPreferredProject((VirtualFile)packageJson, (Project)project);
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        PackageJsonData packageJsonData2 = packageJsonData;
        if (packageJsonData2 == null) {
            PackageJsonData.$$$reportNull$$$0(41);
        }
        return packageJsonData2;
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @NotNull
    public static PackageJsonData getOrCreate(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(42);
        }
        PackageJsonData packageJsonData = (PackageJsonData)VirtualFileUtil.getCachedValue((VirtualFile)packageJson, CACHED_PACKAGE_JSON_DATA_KEY, (boolean)false, file -> !JSLinterExecutionSuppressor.executionIsSuppressed(file.getPath()), PackageJsonData::doParseSafely);
        if (packageJsonData == null) {
            PackageJsonData.$$$reportNull$$$0(43);
        }
        return packageJsonData;
    }

    @NotNull
    private static PackageJsonData doParseSafely(@NotNull VirtualFile packageJsonFile, @Nullable CharSequence text) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(44);
        }
        if (!Strings.isEmpty((CharSequence)text)) {
            try {
                Holder holder = PackageJsonData.doParse(packageJsonFile, text);
                return new PackageJsonData(packageJsonFile, holder);
            }
            catch (Exception e) {
                LOG.debug("Failed to parse " + packageJsonFile.getPath(), (Throwable)e);
            }
        }
        return new PackageJsonData(packageJsonFile, new Holder());
    }

    @NotNull
    private static Holder doParse(@NotNull VirtualFile packageJson, @NotNull CharSequence text) throws IOException {
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(45);
        }
        if (text == null) {
            PackageJsonData.$$$reportNull$$$0(46);
        }
        JsonReader reader = new JsonReader((Reader)new CharSequenceReader(text));
        reader.setStrictness(Strictness.LENIENT);
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Top level element should be an object");
        }
        reader.beginObject();
        Holder holder = new Holder();
        EnumMap<PackageJsonDependency, List<PackageJsonDependencyEntry>> dependenciesByType = new EnumMap<PackageJsonDependency, List<PackageJsonDependencyEntry>>(PackageJsonDependency.class);
        while (reader.hasNext()) {
            String key = reader.nextName();
            holder.topLevelProperties.add(key);
            ThrowablePairConsumer<Holder, JsonReader, IOException> customParser = ourCustomParsers.get(key);
            if (customParser != null) {
                customParser.consume((Object)holder, (Object)reader);
                continue;
            }
            BiConsumer<Holder, String> parser2 = ourParsers.get(key);
            if (parser2 != null) {
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                if (value == null) continue;
                parser2.accept(holder, value);
                continue;
            }
            PackageJsonDependency dependencyType = PackageJsonDependency.findDependencyByName(key);
            if (dependencyType != null) {
                List<PackageJsonDependencyEntry> dependencies = PackageJsonData.readPackages(reader, packageJson, dependencyType);
                dependenciesByType.put(dependencyType, dependencies);
                continue;
            }
            reader.skipValue();
        }
        holder.dependenciesByType = dependenciesByType;
        reader.endObject();
        Holder holder2 = holder;
        if (holder2 == null) {
            PackageJsonData.$$$reportNull$$$0(47);
        }
        return holder2;
    }

    @NotNull
    private static List<PackageJsonDependencyEntry> readPackages(@NotNull JsonReader reader, @NotNull VirtualFile packageJson, @NotNull PackageJsonDependency dependencyType) throws IOException {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(48);
        }
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(49);
        }
        if (dependencyType == null) {
            PackageJsonData.$$$reportNull$$$0(50);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            LOG.info("Failed to parse '" + String.valueOf((Object)dependencyType) + "' of " + packageJson.getPath() + ": expected " + String.valueOf(JsonToken.BEGIN_OBJECT) + ", actual " + String.valueOf(reader.peek()));
            reader.skipValue();
            List<PackageJsonDependencyEntry> list = Collections.emptyList();
            if (list == null) {
                PackageJsonData.$$$reportNull$$$0(51);
            }
            return list;
        }
        reader.beginObject();
        ArrayList<PackageJsonDependencyEntry> packages = new ArrayList<PackageJsonDependencyEntry>();
        while (reader.hasNext()) {
            String name = reader.nextName();
            String version2 = JsonUtil.nextStringOrSkip((JsonReader)reader);
            if (name == null || version2 == null) continue;
            packages.add(new PackageJsonDependencyEntry(name, version2, dependencyType));
        }
        reader.endObject();
        ArrayList<PackageJsonDependencyEntry> arrayList = packages;
        if (arrayList == null) {
            PackageJsonData.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 11, 12, 14, 18, 19, 21, 25, 26, 27, 28, 29, 32, 34, 37, 38, 41, 43, 47, 51, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 47: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = EXPORTS;
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryNameToPathMap";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = MAIN;
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME;
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 40: 
            case 42: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImportsExportsMappings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsFromConditionalExports";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypingsVersionMappings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWorkspaces";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "remapWithPackageName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fixBinaryNameMap";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypingsVersionMappings";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalMains";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryNameToPathMap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebTypes";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencyEntries";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateWithPreferredProject";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyExportsToHolder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseImports";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseImportsExportsMappings";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 47: 
            case 51: 
            case 52: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsFromConditionalExports";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConditionalExport";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseTypingsVersionMappings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseWorkspaces";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "remapWithPackageName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fixBinaryNameMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsDependencyWithScope";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "tryConvertToTypeScript";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOfAnyType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "containsOneOfDependencyOfAnyType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateWithPreferredProject";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doParseSafely";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "readPackages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 11, 12, 14, 18, 19, 21, 25, 26, 27, 28, 29, 32, 34, 37, 38, 41, 43, 47, 51, 52 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        private String myName;
        private final Map<String, @NotNull String> additionalMainProperties = new HashMap<String, String>();
        private String myMain;
        private String myTypings;
        private String myType;
        private String myDescription;
        private Map<String, String> myBinMap = Collections.emptyMap();
        private String myTsConfig;
        private String myVersion;
        private Map<PackageJsonDependency, List<PackageJsonDependencyEntry>> dependenciesByType = Collections.emptyMap();
        private final Set<String> topLevelProperties = new HashSet<String>();
        @Nullable
        private List<String> myWorkspaces = null;
        private Map<String, JSModulePathMappings<JSModulePathSubstitution>> myTypingsVersionMappings = Collections.emptyMap();
        private List<JSModulePathSubstitution> myImports = Collections.emptyList();
        private List<JSModulePathSubstitution> exports = Collections.emptyList();
        private List<String> myWebTypes = Collections.emptyList();
        private String myCustomElements;

        private Holder() {
        }
    }

    public static final class PackageJsonDependencyEntry {
        @NotNull
        private final String myName;
        @NotNull
        private final String myVersionRange;
        @NotNull
        private final PackageJsonDependency myDependencyType;

        PackageJsonDependencyEntry(@NotNull String name, @NotNull String versionRange, @NotNull PackageJsonDependency dependencyType) {
            if (name == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(0);
            }
            if (versionRange == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(1);
            }
            if (dependencyType == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(2);
            }
            this.myName = name;
            this.myVersionRange = versionRange;
            this.myDependencyType = dependencyType;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public SemVer parseVersion() {
            String version2 = this.getVersionRange();
            if (Strings.isEmpty((String)version2)) {
                return null;
            }
            String versionStr = !Strings.isDecimalDigit((char)version2.charAt(0)) ? version2.substring(1) : version2;
            return SemVer.parseFromText((String)versionStr);
        }

        @NotNull
        public String getVersionRange() {
            String string = this.myVersionRange;
            if (string == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public PackageJsonDependency getDependencyType() {
            PackageJsonDependency packageJsonDependency = this.myDependencyType;
            if (packageJsonDependency == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(5);
            }
            return packageJsonDependency;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = PackageJsonData.NAME;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/PackageJsonData$PackageJsonDependencyEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/PackageJsonData$PackageJsonDependencyEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersionRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencyType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

