/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.BeforeRunTaskAwareConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoNameUtils;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.lang.javascript.buildTools.npm.rc.StartBrowserSettingsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunConfiguration
extends AbstractNodeTargetRunProfile
implements NodeDebugRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
BeforeRunTaskAwareConfiguration,
StartBrowserSettingsHolder {
    private NpmRunSettings myRunSettings;
    private StartBrowserSettings myStartBrowserSettings;

    public NpmRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            NpmRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            NpmRunConfiguration.$$$reportNull$$$0(1);
        }
        if (name == null) {
            NpmRunConfiguration.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
        this.myRunSettings = NpmRunSettings.builder().build();
        this.myStartBrowserSettings = new StartBrowserSettings();
    }

    @NotNull
    public NpmRunSettings getRunSettings() {
        NpmRunSettings npmRunSettings = this.myRunSettings;
        if (npmRunSettings == null) {
            NpmRunConfiguration.$$$reportNull$$$0(3);
        }
        return npmRunSettings;
    }

    public void setRunSettings(@NotNull NpmRunSettings runSettings) {
        if (runSettings == null) {
            NpmRunConfiguration.$$$reportNull$$$0(4);
        }
        this.myRunSettings = runSettings;
    }

    public void onNewConfigurationCreated() {
        List<VirtualFile> packageJsonFiles;
        NpmRunSettings runSettings = this.myRunSettings;
        if (runSettings.getPackageJsonSystemIndependentPath().isEmpty() && (packageJsonFiles = NpmScriptsService.getInstance(this.getProject()).detectAllBuildfilesInContentRoots(false)).size() == 1) {
            VirtualFile packageJson = packageJsonFiles.get(0);
            this.myRunSettings = runSettings.toBuilder().setPackageJsonPath(packageJson.getPath()).build();
        }
    }

    @Override
    public void readConfiguration(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            NpmRunConfiguration.$$$reportNull$$$0(5);
        }
        this.setRunSettings(NpmRunSettings.readExternal(element2));
    }

    @Override
    public void writeConfiguration(@NotNull Element element2) {
        if (element2 == null) {
            NpmRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myRunSettings.writeExternal(element2);
    }

    @NotNull
    public NpmRunConfigurationEditor createConfigurationEditor() {
        return new NpmRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        StartBrowserSettingsHolder.Companion.checkBrowserSettings(this.myStartBrowserSettings);
        NpmRunConfigurationUtil.check(this.getProject(), this.myRunSettings);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            NpmRunConfiguration.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            NpmRunConfiguration.$$$reportNull$$$0(8);
        }
        return new NpmRunProfileState(this, environment);
    }

    @Nullable
    public String getActionName() {
        if (JSMonorepoNameUtils.isComposed(this.getName()) && this.isGeneratedName()) {
            return NpmRunConfiguration.suggestNameWithoutPackageName(this.myRunSettings);
        }
        return super.getActionName();
    }

    @Nullable
    public String suggestedName() {
        NpmRunSettings runSettings = this.myRunSettings;
        VirtualFile packageJson = LocalFileSystem.getInstance().findFileByPath(runSettings.getPackageJsonSystemIndependentPath());
        String contextPackageName = JSMonorepoNameUtils.guessContextPackageName(this.getProject(), packageJson);
        String nameWithoutPackageName = NpmRunConfiguration.suggestNameWithoutPackageName(runSettings);
        return JSMonorepoNameUtils.buildContextName(contextPackageName, nameWithoutPackageName);
    }

    @Override
    @NotNull
    public StartBrowserSettings getStartBrowserSettings() {
        StartBrowserSettings startBrowserSettings = this.myStartBrowserSettings;
        if (startBrowserSettings == null) {
            NpmRunConfiguration.$$$reportNull$$$0(9);
        }
        return startBrowserSettings;
    }

    @Override
    public void setStartBrowserSettings(@NotNull StartBrowserSettings settings) {
        if (settings == null) {
            NpmRunConfiguration.$$$reportNull$$$0(10);
        }
        this.myStartBrowserSettings = settings;
    }

    @NotNull
    @Nls
    private static String suggestNameWithoutPackageName(@NotNull NpmRunSettings runSettings) {
        if (runSettings == null) {
            NpmRunConfiguration.$$$reportNull$$$0(11);
        }
        @Nls StringBuilder builder2 = new StringBuilder();
        if (runSettings.getCommand() == NpmCommand.RUN_SCRIPT) {
            int lengthBefore = builder2.length();
            StringUtil.join(runSettings.getScriptNames(), (String)" ", (StringBuilder)builder2);
            if (builder2.length() == lengthBefore) {
                builder2.append(runSettings.getCommand().getCliOption());
            }
        } else {
            builder2.append(runSettings.getCommand().getCliOption());
        }
        String args = runSettings.getArguments().trim();
        if (!args.isEmpty()) {
            builder2.append(" ").append(args);
        }
        String string = builder2.toString();
        if (string == null) {
            NpmRunConfiguration.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myRunSettings.getInterpreterRef().resolve(this.getProject());
    }

    @Override
    public int getConfiguredDebugPort() {
        return NodeCommandLineUtil.findDebugPort(this.myRunSettings.getNodeOptions());
    }

    public boolean useRunExecutor() {
        return true;
    }

    @Override
    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myRunSettings.getEnvData();
        if (environmentVariablesData == null) {
            NpmRunConfiguration.$$$reportNull$$$0(13);
        }
        return environmentVariablesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartBrowserSettings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNameWithoutPackageName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setStartBrowserSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "suggestNameWithoutPackageName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

