/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileWithConfigAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileCurrentFileAction
extends TypeScriptCompileWithConfigAction {
    public TypeScriptCompileCurrentFileAction() {
        super(JavaScriptBundle.message("typescript.compiler.action.compile.current", new Object[0]), null, null);
    }

    @Override
    protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
        return FileEditorManager.getInstance((Project)project).getSelectedFiles();
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || DumbService.isDumb((Project)project)) {
            return;
        }
        VirtualFile[] files = this.getFiles(project, e.getDataContext());
        if (files.length == 1 && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(files[0].getFileType())) {
            VirtualFile file = files[0];
            String path2 = TypeScriptCompileCurrentFileAction.getPresentablePath(project, file);
            e.getPresentation().setText(path2);
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NlsSafe
    @NotNull
    public static String getPresentablePath(Project project, VirtualFile file) {
        String result2;
        VirtualFile dir = ProjectUtil.guessProjectDir((Project)project);
        String presentable = file.getPresentableUrl();
        String string = result2 = dir == null ? presentable : (String)ObjectUtils.coalesce((Object)VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)dir), (Object)presentable);
        if (string == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected VirtualFile getConfigFile(@Nullable DataContext context2) {
        return TypeScriptCompileCurrentFileAction.getTypeScriptConfigVirtualFile(context2);
    }

    @Override
    @NotNull
    protected Consumer<ProgressIndicator> compileWithoutConfig(@NotNull Project project, @Nullable DataContext context2) {
        if (project == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(2);
        }
        VirtualFile[] files = this.getFiles(project, context2);
        Consumer consumer = indicator -> this.runCompile(project, (ProgressIndicator)indicator, files);
        if (consumer == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(3);
        }
        return consumer;
    }

    @Override
    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(4);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompileCurrentFileAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompileCurrentFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compileWithoutConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compileWithoutConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canUseOnlyConfigs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

