/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternal;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0011H\u0016J-\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001dH$\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010&H\u0096\u0002J\u0016\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010)J\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010*\u001a\u00020+H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020\u0011H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\b\u0010.\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/DataColumnImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/DataColumnInternal;", "values", "", "name", "", "type", "Lkotlin/reflect/KType;", "distinct", "Lkotlin/Lazy;", "", "(Ljava/util/List;Ljava/lang/String;Lkotlin/reflect/KType;Lkotlin/Lazy;)V", "getDistinct", "()Lkotlin/Lazy;", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "getName", "()Ljava/lang/String;", "getType", "()Lkotlin/reflect/KType;", "getValues", "()Ljava/util/List;", "contains", "", "value", "(Ljava/lang/Object;)Z", "countDistinct", "createWithValues", "hasNulls", "(Ljava/util/List;Ljava/lang/Boolean;)Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "equals", "other", "", "get", "index", "(I)Ljava/lang/Object;", "range", "Lkotlin/ranges/IntRange;", "size", "toSet", "toString", "core"})
public abstract class DataColumnImpl<T>
implements DataColumn<T>,
DataColumnInternal<T> {
    @NotNull
    private final List<T> values;
    @NotNull
    private final String name;
    @NotNull
    private final KType type;
    @NotNull
    private final Lazy<Set<T>> distinct;
    @NotNull
    private final Lazy hashCode$delegate;

    public DataColumnImpl(@NotNull List<? extends T> values2, @NotNull String name, @NotNull KType type, @Nullable Lazy<? extends Set<? extends T>> distinct2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.values = values2;
        this.name = name;
        this.type = type;
        Lazy lazy = distinct2;
        if (lazy == null) {
            lazy = LazyKt.lazy((Function0)new Function0<Set<? extends T>>(this){
                final /* synthetic */ DataColumnImpl<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Set<T> invoke() {
                    return CollectionsKt.toSet((Iterable)this.this$0.getValues());
                }
            });
        }
        this.distinct = lazy;
        this.hashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DataColumnImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return UtilsKt.getHashCode((DataColumn)this.this$0);
            }
        }));
    }

    public /* synthetic */ DataColumnImpl(List list, String string, KType kType, Lazy lazy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            lazy = null;
        }
        this(list, string, kType, lazy);
    }

    @NotNull
    protected final List<T> getValues() {
        return this.values;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final KType getType() {
        return this.type;
    }

    @NotNull
    protected final Lazy<Set<T>> getDistinct() {
        return this.distinct;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public List<T> values() {
        return this.values;
    }

    @Override
    @NotNull
    public KType type() {
        return this.type;
    }

    @Override
    @NotNull
    public Set<T> toSet() {
        return (Set)this.distinct.getValue();
    }

    @Override
    public boolean contains(T value) {
        return this.distinct.isInitialized() ? ((Set)this.distinct.getValue()).contains(value) : this.values.contains(value);
    }

    @NotNull
    public String toString() {
        BaseColumn[] baseColumnArray = new BaseColumn[]{this};
        return ConstructorsKt.dataFrameOf(baseColumnArray).toString();
    }

    @Override
    public int countDistinct() {
        return this.toSet().size();
    }

    @Override
    public T get(int index) {
        return this.values.get(index);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public boolean equals(@Nullable Object other) {
        return UtilsKt.checkEquals(this, other);
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int hashCode() {
        return this.getHashCode();
    }

    @Override
    @NotNull
    public DataColumn<T> get(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return DataColumnImpl.createWithValues$default(this, this.values.subList(range.getFirst(), range.getLast() + 1), null, 2, null);
    }

    @NotNull
    protected abstract DataColumn<T> createWithValues(@NotNull List<? extends T> var1, @Nullable Boolean var2);

    public static /* synthetic */ DataColumn createWithValues$default(DataColumnImpl dataColumnImpl, List list, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createWithValues");
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        return dataColumnImpl.createWithValues(list, bl);
    }

    @Override
    @NotNull
    public BaseColumn<T> get(int firstIndex, int ... otherIndices) {
        return DataColumn.DefaultImpls.get(this, firstIndex, otherIndices);
    }

    @Override
    public T get(@NotNull DataRow<?> row) {
        return DataColumn.DefaultImpls.get(this, row);
    }

    @Override
    public boolean hasNulls() {
        return DataColumn.DefaultImpls.hasNulls(this);
    }

    @Override
    @Nullable
    public ColumnWithPath<T> resolveSingle(@NotNull ColumnResolutionContext context) {
        return DataColumn.DefaultImpls.resolveSingle(this, context);
    }

    @Override
    @NotNull
    public DataColumn<T> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        return DataColumn.DefaultImpls.getValue(this, thisRef, property);
    }

    @Override
    public T getValue(@NotNull DataRow<?> row) {
        return DataColumn.DefaultImpls.getValue(this, row);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return DataColumn.DefaultImpls.iterator(this);
    }

    @Override
    @NotNull
    public List<T> toList() {
        return DataColumn.DefaultImpls.toList(this);
    }

    @Override
    @NotNull
    public ColumnPath path() {
        return DataColumn.DefaultImpls.path(this);
    }

    @Override
    @Nullable
    public T getValueOrNull(@NotNull DataRow<?> row) {
        return DataColumn.DefaultImpls.getValueOrNull(this, row);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<T>> resolve(@NotNull ColumnResolutionContext context) {
        return DataColumn.DefaultImpls.resolve(this, context);
    }
}

