/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.chrome.wip;

import com.intellij.javascript.debugger.JSCachingFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipStyleSheet;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.CSSStyleSheetHeaderValue;
import org.jetbrains.wip.protocol.css.StyleSheetAddedEventData;
import org.jetbrains.wip.protocol.css.StyleSheetChangedEventData;
import org.jetbrains.wip.protocol.css.StyleSheetRemovedEventData;
import org.jetbrains.wip.protocol.page.FrameDetachedEventData;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002J\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/chrome/wip/WipCssManager;", "", "process", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "idToStyleSheet", "", "", "Lorg/jetbrains/wip/WipStyleSheet;", "getIdToStyleSheet", "()Ljava/util/Map;", "enable", "", "handleEvent", "event", "clear", "setCssSourceMap", "sheet", "Companion", "intellij.javascript.debugger"})
public final class WipCssManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaScriptDebugProcess<?> process;
    @NotNull
    private final Map<String, WipStyleSheet> idToStyleSheet;
    @NotNull
    private static final Logger LOG;

    public WipCssManager(@NotNull JavaScriptDebugProcess<?> process2) {
        Intrinsics.checkNotNullParameter(process2, (String)"process");
        this.process = process2;
        this.idToStyleSheet = new HashMap();
    }

    @NotNull
    public final Map<String, WipStyleSheet> getIdToStyleSheet() {
        return this.idToStyleSheet;
    }

    public final void enable() {
        block0: {
            Vm vm = this.process.getMainVm();
            WipVm wipVm = vm instanceof WipVm ? (WipVm)vm : null;
            if (wipVm == null) break block0;
            WipVm vm2 = wipVm;
            boolean bl = false;
            vm2.getCommandProcessor().send((Request)CSSKt.Enable());
            vm2.getCommandProcessor().send((Request)CSSKt.Enable());
            EventType[] eventTypeArray = new EventType[]{StyleSheetAddedEventData.TYPE, StyleSheetRemovedEventData.TYPE, FrameDetachedEventData.TYPE, FrameNavigatedEventData.TYPE, StyleSheetChangedEventData.TYPE};
            vm2.getCommandProcessor().getEventMap().addMulti(eventTypeArray, arg_0 -> WipCssManager.enable$lambda$1$lambda$0(this, arg_0));
        }
    }

    private final void handleEvent(Object event) {
        block8: {
            block6: {
                CSSStyleSheetHeaderValue styleSheetInfo;
                block7: {
                    if (!(event instanceof StyleSheetAddedEventData)) break block6;
                    styleSheetInfo = ((StyleSheetAddedEventData)event).header();
                    if (!StringUtil.isEmpty((String)styleSheetInfo.sourceURL())) break block7;
                    LOG.warn("CSS " + styleSheetInfo.styleSheetId() + " has empty source URL, sourcemap URL " + styleSheetInfo.getSourceMapURL());
                    break block8;
                }
                Url parsed = Urls.parseEncoded((String)styleSheetInfo.sourceURL());
                if (parsed == null) break block8;
                WipStyleSheet styleSheet = new WipStyleSheet(parsed, styleSheetInfo);
                this.idToStyleSheet.put(styleSheetInfo.styleSheetId(), styleSheet);
                this.setCssSourceMap(styleSheet);
                break block8;
            }
            if (event instanceof StyleSheetRemovedEventData) {
                String styleSheetId = ((StyleSheetRemovedEventData)event).styleSheetId();
                this.idToStyleSheet.remove(styleSheetId);
            } else if (!(event instanceof StyleSheetChangedEventData)) {
                String string;
                if (event instanceof FrameDetachedEventData) {
                    string = ((FrameDetachedEventData)event).frameId();
                } else {
                    Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type org.jetbrains.wip.protocol.page.FrameNavigatedEventData");
                    string = ((FrameNavigatedEventData)event).frame().id();
                }
                String frameId = string;
                Iterator<Map.Entry<String, WipStyleSheet>> iterator = this.idToStyleSheet.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, WipStyleSheet> entry = iterator.next();
                    String id = entry.getKey();
                    WipStyleSheet stylesheet = entry.getValue();
                    if (!Intrinsics.areEqual((Object)stylesheet.getDescriptor().frameId(), (Object)frameId)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public final void clear() {
        this.idToStyleSheet.clear();
    }

    private final void setCssSourceMap(WipStyleSheet sheet) {
        block2: {
            String string = sheet.getDescriptor().getSourceMapURL();
            if (string == null) break block2;
            String sourceMapUrl = string;
            boolean bl = false;
            Url parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, sheet.getUrl());
            SourceMap sourceMap = SourceMapLoaderKt.findSourceMap(parsedUrl, this.process);
            if (sourceMap != null) {
                SourceMap sourceMap2 = sourceMap;
                boolean bl2 = false;
                sheet.setSourceMap(sourceMap2);
                int n = sourceMap2.getSources().length;
                for (int i = 0; i < n; ++i) {
                    JSCachingFileFinder jSCachingFileFinder = this.process.getFinder();
                    Url url = sourceMap2.getSources()[i];
                    Project project = this.process.getSession().getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    JSCachingFileFinder.findFile$default(jSCachingFileFinder, url, project, false, sourceMap2.getSourceContent(i), null, 16, null);
                }
            }
        }
    }

    private static final Unit enable$lambda$1$lambda$0(WipCssManager this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleEvent(it);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(WipCssManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/chrome/wip/WipCssManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

