/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.DropPsiListItemFix;
import com.intellij.sql.inspections.SqlCaseVsCoalesceInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.dataflow.SqlDataFlowRunner;
import com.intellij.sql.inspections.dataflow.sql.SqlDfaListener;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlDfaAnchor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantCodeInCoalesceInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "ReplaceWithFirstArgumentFix", "Holder", "intellij.database.sql.impl"})
public final class SqlRedundantCodeInCoalesceInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        String string = SqlCaseVsCoalesceInspection.Holder.INSTANCE.getCoalesceName(dialect);
        if (string == null) {
            return null;
        }
        String coalesceName = string;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, coalesceName, onTheFly){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ String $coalesceName;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$dialect = $dialect;
                this.$coalesceName = $coalesceName;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlFunctionCallExpression(o);
                BuiltinFunction builtinFunction = o.getFunctionDefinition();
                if (!Intrinsics.areEqual((Object)(builtinFunction != null ? builtinFunction.getName() : null), (Object)this.$coalesceName)) {
                    return;
                }
                SqlExpressionList sqlExpressionList = o.getParameterList();
                if (sqlExpressionList == null) {
                    return;
                }
                SqlExpressionList argumentList = sqlExpressionList;
                List list = argumentList.getExpressionList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
                List arguments = list;
                if (arguments.size() == 1) {
                    SqlReferenceExpression sqlReferenceExpression = o.getNameElement();
                    this.reportProblem((PsiElement)o, (TextRange)(sqlReferenceExpression != null ? sqlReferenceExpression.getTextRangeInParent() : null), (LocalQuickFix)ReplaceWithFirstArgumentFix.INSTANCE);
                }
                List<PsiElement> notNullArgs = this.findNotNullArguments(o);
                Iterator<T> iterator = ((Iterable)arguments).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    SqlExpression argument = (SqlExpression)iterator.next();
                    if (argument instanceof SqlSpecialLiteralExpression && ((SqlSpecialLiteralExpression)argument).isNull()) {
                        this.reportProblem((PsiElement)argument, (PsiElement)argument, Holder.INSTANCE.getDROP_ARGUMENT_FIX());
                        continue;
                    }
                    if (i >= CollectionsKt.getLastIndex((List)arguments) || !notNullArgs.contains(argument)) continue;
                    PsiElement psiElement = argument.getNextSibling();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement psiElement2 = argumentList.getLastChild();
                    if (psiElement2 == null) {
                        return;
                    }
                    this.reportProblem(psiElement, psiElement2, (LocalQuickFix)DropPsiFix.Companion.getINSTANCE());
                    if (i != 0) break;
                    SqlReferenceExpression sqlReferenceExpression = o.getNameElement();
                    this.reportProblem((PsiElement)o, (TextRange)(sqlReferenceExpression != null ? sqlReferenceExpression.getTextRangeInParent() : null), (LocalQuickFix)ReplaceWithFirstArgumentFix.INSTANCE);
                    break;
                }
            }

            private final void reportProblem(PsiElement startElement, PsiElement endElement, LocalQuickFix fix) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                this.addDescriptor(this.myManager.createProblemDescriptor(startElement, endElement, SqlBundle.message((String)"inspection.message.redundant.code.in.coalesce.call", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, localQuickFixArray));
            }

            private final void reportProblem(PsiElement element, TextRange range, LocalQuickFix fix) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                this.addDescriptor(this.myManager.createProblemDescriptor(element, range, SqlBundle.message((String)"inspection.message.redundant.code.in.coalesce.call", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, localQuickFixArray));
            }

            private final List<PsiElement> findNotNullArguments(SqlFunctionCallExpression call) {
                if (this.isNullableDueToGrouping(call)) {
                    return CollectionsKt.emptyList();
                }
                SqlStatement sqlStatement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)call), SqlStatement.class);
                if (sqlStatement == null) {
                    return CollectionsKt.emptyList();
                }
                SqlStatement statement2 = sqlStatement;
                Project project = statement2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SqlDataFlowRunner runner = new SqlDataFlowRunner(project, null, 2, null);
                ControlFlow flow = runner.buildFlow((PsiElement)statement2, this.$dialect);
                if (flow == null) {
                    return CollectionsKt.emptyList();
                }
                List res2 = new ArrayList<E>();
                SqlDfaListener listener2 = new SqlDfaListener(res2){
                    final /* synthetic */ List<PsiElement> $res;
                    {
                        this.$res = $res;
                    }

                    public void beforePush(DfaValue[] unused, DfaValue value, DfaAnchor anchor, DfaMemoryState state) {
                        Intrinsics.checkNotNullParameter((Object)unused, (String)"unused");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        if (!(anchor instanceof SqlDfaAnchor)) {
                            return;
                        }
                        DfType dfType = state.getDfType(value);
                        Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
                        DfType dfType2 = dfType;
                        if (SqlDfTypesKt.isNotNull((DfType)dfType2)) {
                            this.$res.add(((SqlDfaAnchor)anchor).getElement());
                        }
                    }
                };
                if (runner.analyzeFlow((DfaListener)listener2, (Collection)CollectionsKt.listOf((Object)runner.createMemoryState()), flow) != RunnerResult.OK) {
                    return CollectionsKt.emptyList();
                }
                return res2;
            }

            private final boolean isNullableDueToGrouping(SqlFunctionCallExpression call) {
                boolean bl;
                block5: {
                    Class[] classArray = new Class[]{SqlQueryExpression.class};
                    SqlSelectClause sqlSelectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)call), SqlSelectClause.class, (boolean)true, (Class[])classArray);
                    if (sqlSelectClause == null) {
                        return false;
                    }
                    SqlSelectClause selectClause = sqlSelectClause;
                    PsiElement psiElement = selectClause.getParent();
                    SqlQueryExpression sqlQueryExpression = psiElement instanceof SqlQueryExpression ? (SqlQueryExpression)psiElement : null;
                    if (sqlQueryExpression == null || (sqlQueryExpression = sqlQueryExpression.getTableExpression()) == null || (sqlQueryExpression = sqlQueryExpression.getGroupByClause()) == null) {
                        sqlQueryExpression = (SqlGroupByClause)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)selectClause), SqlGroupByClause.class);
                    }
                    SqlQueryExpression groupByClause = sqlQueryExpression;
                    JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)groupByClause));
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"sqlChildren(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!Holder.INSTANCE.getGROUPING_SET_TOKENS().contains(PsiUtilCore.getElementType((PsiElement)it))) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantCodeInCoalesceInspection$Holder;", "", "<init>", "()V", "DROP_ARGUMENT_FIX", "Lcom/intellij/codeInspection/LocalQuickFix;", "getDROP_ARGUMENT_FIX", "()Lcom/intellij/codeInspection/LocalQuickFix;", "GROUPING_SET_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "getGROUPING_SET_TOKENS", "()Lcom/intellij/psi/tree/TokenSet;", "intellij.database.sql.impl"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final LocalQuickFix DROP_ARGUMENT_FIX = (LocalQuickFix)new DropPsiListItemFix("argument", SqlExpression.class, false, 4, null);
        @NotNull
        private static final TokenSet GROUPING_SET_TOKENS;

        private Holder() {
        }

        @NotNull
        public final LocalQuickFix getDROP_ARGUMENT_FIX() {
            return DROP_ARGUMENT_FIX;
        }

        @NotNull
        public final TokenSet getGROUPING_SET_TOKENS() {
            return GROUPING_SET_TOKENS;
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{SqlCommonKeywords.SQL_GROUPING, SqlCommonKeywords.SQL_CUBE, SqlCommonKeywords.SQL_ROLLUP};
            TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
            GROUPING_SET_TOKENS = tokenSet;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantCodeInCoalesceInspection$ReplaceWithFirstArgumentFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.sql.impl"})
    public static final class ReplaceWithFirstArgumentFix
    implements LocalQuickFix,
    DumbAware {
        @NotNull
        public static final ReplaceWithFirstArgumentFix INSTANCE = new ReplaceWithFirstArgumentFix();

        private ReplaceWithFirstArgumentFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.replace.with.first.argument", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Object object;
            SqlFunctionCallExpression callExpression;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    PsiElement psiElement = descriptor2.getStartElement();
                    SqlFunctionCallExpression sqlFunctionCallExpression = psiElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)psiElement : null;
                    if (sqlFunctionCallExpression == null) {
                        return;
                    }
                    callExpression = sqlFunctionCallExpression;
                    object = callExpression.getParameterList();
                    if (object == null || (object = object.getExpressionList()) == null || (object = (SqlExpression)CollectionsKt.firstOrNull((List)object)) == null) break block4;
                    Object it = object;
                    boolean bl = false;
                    Object object2 = it instanceof SqlNamedParameterValueExpression ? ((SqlNamedParameterValueExpression)it).getROperand() : it;
                    object = object2;
                    if (object2 != null) break block5;
                }
                return;
            }
            Object firstArgument = object;
            callExpression.replace((PsiElement)firstArgument);
        }
    }
}

