/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl.parser;

import com.intellij.httpClient.converters.curl.parser.QuotesOutside;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HttpRequestCurlTokenizer {
    @NotNull
    public static List<String> splitInCurlTokens(@NotNull String curlString) {
        if (curlString == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(0);
        }
        ArrayList<String> tokensList = new ArrayList<String>();
        int curlStringLength = curlString.length();
        QuotesOutside quotesOutside = QuotesOutside.NONE;
        StringBuilder curToken = new StringBuilder();
        block5: for (int i = 0; i < curlStringLength; ++i) {
            char c = curlString.charAt(i);
            switch (c) {
                case '\"': {
                    if (quotesOutside == QuotesOutside.SINGLE) {
                        curToken.append(c);
                        continue block5;
                    }
                    if (quotesOutside == QuotesOutside.DOUBLE && curToken.isEmpty()) {
                        tokensList.add("");
                        continue block5;
                    }
                    HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
                    quotesOutside = HttpRequestCurlTokenizer.updateQuotesState(quotesOutside, Character.valueOf('\"'));
                    continue block5;
                }
                case '\'': {
                    if (quotesOutside == QuotesOutside.DOUBLE) {
                        curToken.append(c);
                        continue block5;
                    }
                    if (quotesOutside == QuotesOutside.SINGLE && curToken.isEmpty()) {
                        tokensList.add("");
                        continue block5;
                    }
                    HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
                    quotesOutside = HttpRequestCurlTokenizer.updateQuotesState(quotesOutside, Character.valueOf('\''));
                    continue block5;
                }
                case '\\': {
                    if (curlStringLength > i + 1 && (curlString.charAt(i + 1) == '\"' || curlString.charAt(i + 1) == '\'')) {
                        curToken.append(curlString.charAt(i + 1));
                        ++i;
                        continue block5;
                    }
                    curToken.append("\\");
                    continue block5;
                }
                default: {
                    if (quotesOutside != QuotesOutside.NONE) {
                        curToken.append(c);
                        continue block5;
                    }
                    if (Character.isWhitespace(c)) {
                        HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
                        continue block5;
                    }
                    curToken.append(c);
                }
            }
        }
        HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
        ArrayList<String> arrayList = tokensList;
        if (arrayList == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static QuotesOutside updateQuotesState(@NotNull QuotesOutside curQuotesState, @NotNull Character curCharacter) {
        if (curQuotesState == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(2);
        }
        if (curCharacter == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(3);
        }
        if (curQuotesState == QuotesOutside.NONE) {
            if (curCharacter.charValue() == '\"') {
                QuotesOutside quotesOutside = QuotesOutside.DOUBLE;
                if (quotesOutside == null) {
                    HttpRequestCurlTokenizer.$$$reportNull$$$0(4);
                }
                return quotesOutside;
            }
            if (curCharacter.charValue() == '\'') {
                QuotesOutside quotesOutside = QuotesOutside.SINGLE;
                if (quotesOutside == null) {
                    HttpRequestCurlTokenizer.$$$reportNull$$$0(5);
                }
                return quotesOutside;
            }
        }
        QuotesOutside quotesOutside = QuotesOutside.NONE;
        if (quotesOutside == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(6);
        }
        return quotesOutside;
    }

    private static void addTokenToList(@NotNull List<String> tokensList, @NotNull StringBuilder token) {
        if (tokensList == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(7);
        }
        if (token == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(8);
        }
        if (!token.isEmpty()) {
            tokensList.add(token.toString());
            token.setLength(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curlString";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/converters/curl/parser/HttpRequestCurlTokenizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curQuotesState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curCharacter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokensList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/converters/curl/parser/HttpRequestCurlTokenizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitInCurlTokens";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "updateQuotesState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitInCurlTokens";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateQuotesState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTokenToList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

