/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.DateUtilsKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import io.ktor.util.date.DateKt;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b*\b\u0012\u0004\u0012\u00020\u00160\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001f\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010\u001aR\u0014\u0010(\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010&\u00a8\u0006)"}, d2={"Lio/ktor/http/content/LastModifiedVersion;", "Lio/ktor/http/content/Version;", "Lio/ktor/util/date/GMTDate;", "lastModified", "<init>", "(Lio/ktor/util/date/GMTDate;)V", "Lio/ktor/http/Headers;", "requestHeaders", "Lio/ktor/http/content/VersionCheckResult;", "check", "(Lio/ktor/http/Headers;)Lio/ktor/http/content/VersionCheckResult;", "", "dates", "", "ifModifiedSince", "(Ljava/util/List;)Z", "ifUnmodifiedSince", "Lio/ktor/http/HeadersBuilder;", "builder", "", "appendHeadersTo", "(Lio/ktor/http/HeadersBuilder;)V", "", "parseDates", "(Ljava/util/List;)Ljava/util/List;", "component1", "()Lio/ktor/util/date/GMTDate;", "copy", "(Lio/ktor/util/date/GMTDate;)Lio/ktor/http/content/LastModifiedVersion;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lio/ktor/util/date/GMTDate;", "getLastModified", "truncatedModificationDate", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\nio/ktor/http/content/LastModifiedVersion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1761#2,3:308\n1740#2,3:311\n774#2:314\n865#2,2:315\n1617#2,9:317\n1869#2:326\n1870#2:328\n1626#2:329\n1#3:327\n1#3:330\n*S KotlinDebug\n*F\n+ 1 Versions.kt\nio/ktor/http/content/LastModifiedVersion\n*L\n123#1:308,3\n132#1:311,3\n140#1:314\n140#1:315,2\n141#1:317,9\n141#1:326\n141#1:328\n141#1:329\n141#1:327\n*E\n"})
public final class LastModifiedVersion
implements Version {
    @NotNull
    private final GMTDate lastModified;
    @NotNull
    private final GMTDate truncatedModificationDate;

    public LastModifiedVersion(@NotNull GMTDate lastModified) {
        Intrinsics.checkNotNullParameter((Object)lastModified, (String)"lastModified");
        this.lastModified = lastModified;
        this.truncatedModificationDate = DateKt.truncateToSeconds((GMTDate)this.lastModified);
    }

    @NotNull
    public final GMTDate getLastModified() {
        return this.lastModified;
    }

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders) {
        List<GMTDate> unmodifiedSince;
        List<GMTDate> modifiedSince;
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        List list = requestHeaders.getAll(HttpHeaders.INSTANCE.getIfModifiedSince());
        List<GMTDate> list2 = modifiedSince = list != null ? this.parseDates(list) : null;
        if (modifiedSince != null && !this.ifModifiedSince(modifiedSince)) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        List list3 = requestHeaders.getAll(HttpHeaders.INSTANCE.getIfUnmodifiedSince());
        List<GMTDate> list4 = unmodifiedSince = list3 != null ? this.parseDates(list3) : null;
        if (unmodifiedSince != null && !this.ifUnmodifiedSince(unmodifiedSince)) {
            return VersionCheckResult.PRECONDITION_FAILED;
        }
        return VersionCheckResult.OK;
    }

    public final boolean ifModifiedSince(@NotNull List<GMTDate> dates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(dates, (String)"dates");
            Iterable $this$any$iv = dates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GMTDate it = (GMTDate)element$iv;
                    boolean bl2 = false;
                    if (!(this.truncatedModificationDate.compareTo(it) > 0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean ifUnmodifiedSince(@NotNull List<GMTDate> dates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(dates, (String)"dates");
            Iterable $this$all$iv = dates;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GMTDate it = (GMTDate)element$iv;
                    boolean bl2 = false;
                    if (this.truncatedModificationDate.compareTo(it) <= 0) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        builder.set(HttpHeaders.INSTANCE.getLastModified(), DateUtilsKt.toHttpDate(this.lastModified));
    }

    /*
     * WARNING - void declaration
     */
    private final List<GMTDate> parseDates(List<String> $this$parseDates) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$parseDates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GMTDate it$iv$iv;
            GMTDate gMTDate;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            try {
                gMTDate = DateUtilsKt.fromHttpToGmtDate(it);
            }
            catch (Throwable throwable) {
                gMTDate = null;
            }
            if (gMTDate == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        return !((Collection)it).isEmpty() ? list : null;
    }

    @NotNull
    public final GMTDate component1() {
        return this.lastModified;
    }

    @NotNull
    public final LastModifiedVersion copy(@NotNull GMTDate lastModified) {
        Intrinsics.checkNotNullParameter((Object)lastModified, (String)"lastModified");
        return new LastModifiedVersion(lastModified);
    }

    public static /* synthetic */ LastModifiedVersion copy$default(LastModifiedVersion lastModifiedVersion, GMTDate gMTDate, int n, Object object) {
        if ((n & 1) != 0) {
            gMTDate = lastModifiedVersion.lastModified;
        }
        return lastModifiedVersion.copy(gMTDate);
    }

    @NotNull
    public String toString() {
        return "LastModifiedVersion(lastModified=" + this.lastModified + ')';
    }

    public int hashCode() {
        return this.lastModified.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LastModifiedVersion)) {
            return false;
        }
        LastModifiedVersion lastModifiedVersion = (LastModifiedVersion)other;
        return Intrinsics.areEqual((Object)this.lastModified, (Object)lastModifiedVersion.lastModified);
    }
}

